/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.0a_r701
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 * 
 */
(function(y){var l;y.jqplot=function(V,S,Q){var R,P;if(Q==null){if(jQuery.isArray(S)){R=S;P=null}else{if(typeof(S)==="object"){R=null;P=S}}}else{R=S;P=Q}var U=new D();y("#"+V).removeClass("jqplot-error");if(y.jqplot.config.catchErrors){try{U.init(V,R,P);U.draw();U.themeEngine.init.call(U);return U}catch(T){var W=y.jqplot.config.errorMessage||T.message;y("#"+V).append('<div class="jqplot-error-message">'+W+"</div>");y("#"+V).addClass("jqplot-error");document.getElementById(V).style.background=y.jqplot.config.errorBackground;document.getElementById(V).style.border=y.jqplot.config.errorBorder;document.getElementById(V).style.fontFamily=y.jqplot.config.errorFontFamily;document.getElementById(V).style.fontSize=y.jqplot.config.errorFontSize;document.getElementById(V).style.fontStyle=y.jqplot.config.errorFontStyle;document.getElementById(V).style.fontWeight=y.jqplot.config.errorFontWeight}}else{U.init(V,R,P);U.draw();U.themeEngine.init.call(U);return U}};y.jqplot.log=function(){if(window.console){console.log.apply(console,arguments)}};y.jqplot.config={enablePlugins:false,defaultHeight:300,defaultWidth:400,UTCAdjust:false,timezoneOffset:new Date(new Date().getTimezoneOffset()*60000),errorMessage:"",errorBackground:"",errorBorder:"",errorFontFamily:"",errorFontSize:"",errorFontStyle:"",errorFontWeight:"",catchErrors:false,defaultTickFormatString:"%.1f"};y.jqplot.arrayMax=function(P){return Math.max.apply(Math,P)};y.jqplot.arrayMin=function(P){return Math.min.apply(Math,P)};y.jqplot.enablePlugins=y.jqplot.config.enablePlugins;y.jqplot.support_canvas=function(){return !!document.createElement("canvas").getContext};y.jqplot.support_canvas_text=function(){return !!(document.createElement("canvas").getContext&&typeof document.createElement("canvas").getContext("2d").fillText=="function")};y.jqplot.use_excanvas=(y.browser.msie&&!y.jqplot.support_canvas())?true:false;y.jqplot.preInitHooks=[];y.jqplot.postInitHooks=[];y.jqplot.preParseOptionsHooks=[];y.jqplot.postParseOptionsHooks=[];y.jqplot.preDrawHooks=[];y.jqplot.postDrawHooks=[];y.jqplot.preDrawSeriesHooks=[];y.jqplot.postDrawSeriesHooks=[];y.jqplot.preDrawLegendHooks=[];y.jqplot.addLegendRowHooks=[];y.jqplot.preSeriesInitHooks=[];y.jqplot.postSeriesInitHooks=[];y.jqplot.preParseSeriesOptionsHooks=[];y.jqplot.postParseSeriesOptionsHooks=[];y.jqplot.eventListenerHooks=[];y.jqplot.preDrawSeriesShadowHooks=[];y.jqplot.postDrawSeriesShadowHooks=[];y.jqplot.ElemContainer=function(){this._elem;this._plotWidth;this._plotHeight;this._plotDimensions={height:null,width:null}};y.jqplot.ElemContainer.prototype.createElement=function(S,U,Q,R,V){this._offsets=U;var P=Q||"jqplot";var T=document.createElement(S);this._elem=y(T);this._elem.addClass(P);this._elem.css(R);this._elem.attr(V);T=null;return this._elem};y.jqplot.ElemContainer.prototype.getWidth=function(){if(this._elem){return this._elem.outerWidth(true)}else{return null}};y.jqplot.ElemContainer.prototype.getHeight=function(){if(this._elem){return this._elem.outerHeight(true)}else{return null}};y.jqplot.ElemContainer.prototype.getPosition=function(){if(this._elem){return this._elem.position()}else{return{top:null,left:null,bottom:null,right:null}}};y.jqplot.ElemContainer.prototype.getTop=function(){return this.getPosition().top};y.jqplot.ElemContainer.prototype.getLeft=function(){return this.getPosition().left};y.jqplot.ElemContainer.prototype.getBottom=function(){return this._elem.css("bottom")};y.jqplot.ElemContainer.prototype.getRight=function(){return this._elem.css("right")};function n(P){y.jqplot.ElemContainer.call(this);this.name=P;this._series=[];this.show=false;this.tickRenderer=y.jqplot.AxisTickRenderer;this.tickOptions={};this.labelRenderer=y.jqplot.AxisLabelRenderer;this.labelOptions={};this.label=null;this.showLabel=true;this.min=null;this.max=null;this.autoscale=false;this.pad=1.2;this.padMax=null;this.padMin=null;this.ticks=[];this.numberTicks;this.tickInterval;this.renderer=y.jqplot.LinearAxisRenderer;this.rendererOptions={};this.showTicks=true;this.showTickMarks=true;this.showMinorTicks=true;this.useSeriesColor=false;this.borderWidth=null;this.borderColor=null;this._dataBounds={min:null,max:null};this._intervalStats=[];this._offsets={min:null,max:null};this._ticks=[];this._label=null;this.syncTicks=null;this.tickSpacing=75;this._min=null;this._max=null;this._tickInterval=null;this._numberTicks=null;this.__ticks=null}n.prototype=new y.jqplot.ElemContainer();n.prototype.constructor=n;n.prototype.init=function(){this.renderer=new this.renderer();this.tickOptions.axis=this.name;if(this.tickOptions.showMark==null){this.tickOptions.showMark=this.showTicks}if(this.tickOptions.showMark==null){this.tickOptions.showMark=this.showTickMarks}if(this.tickOptions.showLabel==null){this.tickOptions.showLabel=this.showTicks}if(this.label==null||this.label==""){this.showLabel=false}else{this.labelOptions.label=this.label}if(this.showLabel==false){this.labelOptions.show=false}if(this.pad==0){this.pad=1}if(this.padMax==0){this.padMax=1}if(this.padMin==0){this.padMin=1}if(this.padMax==null){this.padMax=(this.pad-1)/2+1}if(this.padMin==null){this.padMin=(this.pad-1)/2+1}this.pad=this.padMax+this.padMin-1;if(this.min!=null||this.max!=null){this.autoscale=false}if(this.syncTicks==null&&this.name.indexOf("y")>-1){this.syncTicks=true}else{if(this.syncTicks==null){this.syncTicks=false}}this.renderer.init.call(this,this.rendererOptions)};n.prototype.draw=function(P){return this.renderer.draw.call(this,P)};n.prototype.set=function(){this.renderer.set.call(this)};n.prototype.pack=function(Q,P){if(this.show){this.renderer.pack.call(this,Q,P)}if(this._min==null){this._min=this.min;this._max=this.max;this._tickInterval=this.tickInterval;this._numberTicks=this.numberTicks;this.__ticks=this._ticks}};n.prototype.reset=function(){this.renderer.reset.call(this)};n.prototype.resetScale=function(P){y.extend(true,this,{min:null,max:null,numberTicks:null,tickInterval:null,_ticks:[],ticks:[]},P);this.resetDataBounds()};n.prototype.resetDataBounds=function(){var P=this._dataBounds;P.min=null;P.max=null;for(var R=0;R<this._series.length;R++){var S=this._series[R];var T=S._plotData;for(var Q=0;Q<T.length;Q++){if(this.name=="xaxis"||this.name=="x2axis"){if((T[Q][0]!=null&&T[Q][0]<P.min)||P.min==null){P.min=T[Q][0]}if((T[Q][0]!=null&&T[Q][0]>P.max)||P.max==null){P.max=T[Q][0]}}else{if((T[Q][1]!=null&&T[Q][1]<P.min)||P.min==null){P.min=T[Q][1]}if((T[Q][1]!=null&&T[Q][1]>P.max)||P.max==null){P.max=T[Q][1]}}}}};function g(P){y.jqplot.ElemContainer.call(this);this.show=false;this.location="ne";this.labels=[];this.showLabels=true;this.showSwatches=true;this.placement="insideGrid";this.xoffset=0;this.yoffset=0;this.border;this.background;this.textColor;this.fontFamily;this.fontSize;this.rowSpacing="0.5em";this.renderer=y.jqplot.TableLegendRenderer;this.rendererOptions={};this.preDraw=false;this.marginTop=null;this.marginRight=null;this.marginBottom=null;this.marginLeft=null;this.escapeHtml=false;this._series=[];y.extend(true,this,P)}g.prototype=new y.jqplot.ElemContainer();g.prototype.constructor=g;g.prototype.setOptions=function(P){y.extend(true,this,P);if(this.placement=="inside"){this.placement="insideGrid"}if(this.xoffset>0){if(this.placement=="insideGrid"){switch(this.location){case"nw":case"w":case"sw":if(this.marginLeft==null){this.marginLeft=this.xoffset+"px"}this.marginRight="0px";break;case"ne":case"e":case"se":default:if(this.marginRight==null){this.marginRight=this.xoffset+"px"}this.marginLeft="0px";break}}else{if(this.placement=="outside"){switch(this.location){case"nw":case"w":case"sw":if(this.marginRight==null){this.marginRight=this.xoffset+"px"}this.marginLeft="0px";break;case"ne":case"e":case"se":default:if(this.marginLeft==null){this.marginLeft=this.xoffset+"px"}this.marginRight="0px";break}}}this.xoffset=0}if(this.yoffset>0){if(this.placement=="outside"){switch(this.location){case"sw":case"s":case"se":if(this.marginTop==null){this.marginTop=this.yoffset+"px"}this.marginBottom="0px";break;case"ne":case"n":case"nw":default:if(this.marginBottom==null){this.marginBottom=this.yoffset+"px"}this.marginTop="0px";break}}else{if(this.placement=="insideGrid"){switch(this.location){case"sw":case"s":case"se":if(this.marginBottom==null){this.marginBottom=this.yoffset+"px"}this.marginTop="0px";break;case"ne":case"n":case"nw":default:if(this.marginTop==null){this.marginTop=this.yoffset+"px"}this.marginBottom="0px";break}}}this.yoffset=0}};g.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};g.prototype.draw=function(Q){for(var P=0;P<y.jqplot.preDrawLegendHooks.length;P++){y.jqplot.preDrawLegendHooks[P].call(this,Q)}return this.renderer.draw.call(this,Q)};g.prototype.pack=function(P){this.renderer.pack.call(this,P)};function o(P){y.jqplot.ElemContainer.call(this);this.text=P;this.show=true;this.fontFamily;this.fontSize;this.textAlign;this.textColor;this.renderer=y.jqplot.DivTitleRenderer;this.rendererOptions={}}o.prototype=new y.jqplot.ElemContainer();o.prototype.constructor=o;o.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};o.prototype.draw=function(P){return this.renderer.draw.call(this,P)};o.prototype.pack=function(){this.renderer.pack.call(this)};function E(){y.jqplot.ElemContainer.call(this);this.show=true;this.xaxis="xaxis";this._xaxis;this.yaxis="yaxis";this._yaxis;this.gridBorderWidth=2;this.renderer=y.jqplot.LineRenderer;this.rendererOptions={};this.data=[];this.gridData=[];this.label="";this.showLabel=true;this.color;this.lineWidth=2.5;this.shadow=true;this.shadowAngle=45;this.shadowOffset=1.25;this.shadowDepth=3;this.shadowAlpha="0.1";this.breakOnNull=false;this.markerRenderer=y.jqplot.MarkerRenderer;this.markerOptions={};this.showLine=true;this.showMarker=true;this.index;this.fill=false;this.fillColor;this.fillAlpha;this.fillAndStroke=false;this.disableStack=false;this._stack=false;this.neighborThreshold=4;this.fillToZero=false;this.fillToValue=0;this.fillAxis="y";this.useNegativeColors=true;this._stackData=[];this._plotData=[];this._plotValues={x:[],y:[]};this._intervals={x:{},y:{}};this._prevPlotData=[];this._prevGridData=[];this._stackAxis="y";this._primaryAxis="_xaxis";this.canvas=new y.jqplot.GenericCanvas();this.shadowCanvas=new y.jqplot.GenericCanvas();this.plugins={};this._sumy=0;this._sumx=0}E.prototype=new y.jqplot.ElemContainer();E.prototype.constructor=E;E.prototype.init=function(R,V,T){this.index=R;this.gridBorderWidth=V;var U=this.data;var Q=[],S;for(S=0;S<U.length;S++){if(!this.breakOnNull){if(U[S]==null||U[S][0]==null||U[S][1]==null){continue}else{Q.push(U[S])}}else{Q.push(U[S])}}this.data=Q;if(!this.fillColor){this.fillColor=this.color}if(this.fillAlpha){var P=y.jqplot.normalize2rgb(this.fillColor);var P=y.jqplot.getColorComponents(P);this.fillColor="rgba("+P[0]+","+P[1]+","+P[2]+","+this.fillAlpha+")"}this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions,T);this.markerRenderer=new this.markerRenderer();if(!this.markerOptions.color){this.markerOptions.color=this.color}if(this.markerOptions.show==null){this.markerOptions.show=this.showMarker}this.showMarker=this.markerOptions.show;this.markerRenderer.init(this.markerOptions)};E.prototype.draw=function(V,S,U){var Q=(S==l)?{}:S;V=(V==l)?this.canvas._ctx:V;var P,T,R;for(P=0;P<y.jqplot.preDrawSeriesHooks.length;P++){y.jqplot.preDrawSeriesHooks[P].call(this,V,Q)}if(this.show){this.renderer.setGridData.call(this,U);if(!Q.preventJqPlotSeriesDrawTrigger){y(V.canvas).trigger("jqplotSeriesDraw",[this.data,this.gridData])}T=[];if(Q.data){T=Q.data}else{if(!this._stack){T=this.data}else{T=this._plotData}}R=Q.gridData||this.renderer.makeGridData.call(this,T,U);this.renderer.draw.call(this,V,R,Q,U)}for(P=0;P<y.jqplot.postDrawSeriesHooks.length;P++){y.jqplot.postDrawSeriesHooks[P].call(this,V,Q)}V=S=U=P=T=R=null};E.prototype.drawShadow=function(V,S,U){var Q=(S==l)?{}:S;V=(V==l)?this.shadowCanvas._ctx:V;var P,T,R;for(P=0;P<y.jqplot.preDrawSeriesShadowHooks.length;P++){y.jqplot.preDrawSeriesShadowHooks[P].call(this,V,Q)}if(this.shadow){this.renderer.setGridData.call(this,U);T=[];if(Q.data){T=Q.data}else{if(!this._stack){T=this.data}else{T=this._plotData}}R=Q.gridData||this.renderer.makeGridData.call(this,T,U);this.renderer.drawShadow.call(this,V,R,Q)}for(P=0;P<y.jqplot.postDrawSeriesShadowHooks.length;P++){y.jqplot.postDrawSeriesShadowHooks[P].call(this,V,Q)}V=S=U=P=T=R=null};E.prototype.toggleDisplay=function(Q){var P,R;if(Q.data.series){P=Q.data.series}else{P=this}if(Q.data.speed){R=Q.data.speed}if(R){if(P.canvas._elem.is(":hidden")){if(P.shadowCanvas._elem){P.shadowCanvas._elem.fadeIn(R)}P.canvas._elem.fadeIn(R);P.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+P.index).fadeIn(R)}else{if(P.shadowCanvas._elem){P.shadowCanvas._elem.fadeOut(R)}P.canvas._elem.fadeOut(R);P.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+P.index).fadeOut(R)}}else{if(P.canvas._elem.is(":hidden")){if(P.shadowCanvas._elem){P.shadowCanvas._elem.show()}P.canvas._elem.show();P.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+P.index).show()}else{if(P.shadowCanvas._elem){P.shadowCanvas._elem.hide()}P.canvas._elem.hide();P.canvas._elem.nextAll(".jqplot-point-label.jqplot-series-"+P.index).hide()}}};function z(){y.jqplot.ElemContainer.call(this);this.drawGridlines=true;this.gridLineColor="#cccccc";this.gridLineWidth=1;this.background="#fffdf6";this.borderColor="#999999";this.borderWidth=2;this.drawBorder=true;this.shadow=true;this.shadowAngle=45;this.shadowOffset=1.5;this.shadowWidth=3;this.shadowDepth=3;this.shadowColor=null;this.shadowAlpha="0.07";this._left;this._top;this._right;this._bottom;this._width;this._height;this._axes=[];this.renderer=y.jqplot.CanvasGridRenderer;this.rendererOptions={};this._offsets={top:null,bottom:null,left:null,right:null}}z.prototype=new y.jqplot.ElemContainer();z.prototype.constructor=z;z.prototype.init=function(){this.renderer=new this.renderer();this.renderer.init.call(this,this.rendererOptions)};z.prototype.createElement=function(P){this._offsets=P;return this.renderer.createElement.call(this)};z.prototype.draw=function(){this.renderer.draw.call(this)};y.jqplot.GenericCanvas=function(){y.jqplot.ElemContainer.call(this);this._ctx};y.jqplot.GenericCanvas.prototype=new y.jqplot.ElemContainer();y.jqplot.GenericCanvas.prototype.constructor=y.jqplot.GenericCanvas;y.jqplot.GenericCanvas.prototype.createElement=function(T,R,Q){this._offsets=T;var P="jqplot";if(R!=l){P=R}var S;if(this._elem){S=this._elem.get(0)}else{S=document.createElement("canvas")}if(Q!=l){this._plotDimensions=Q}S.width=this._plotDimensions.width-this._offsets.left-this._offsets.right;S.height=this._plotDimensions.height-this._offsets.top-this._offsets.bottom;this._elem=y(S);this._elem.css({position:"absolute",left:this._offsets.left,top:this._offsets.top});this._elem.addClass(P);if(y.jqplot.use_excanvas){window.G_vmlCanvasManager.init_(document);S=window.G_vmlCanvasManager.initElement(S)}S=null;return this._elem};y.jqplot.GenericCanvas.prototype.setContext=function(){this._ctx=this._elem.get(0).getContext("2d");return this._ctx};y.jqplot.HooksManager=function(){this.hooks=[]};y.jqplot.HooksManager.prototype.addOnce=function(Q){var R=false,P;for(P=0;P<this.hooks.length;P++){if(this.hooks[P][0]==Q){R=true}}if(!R){this.hooks.push(Q)}};y.jqplot.HooksManager.prototype.add=function(P){this.hooks.push(P)};y.jqplot.EventListenerManager=function(){this.hooks=[]};y.jqplot.EventListenerManager.prototype.addOnce=function(S,R){var T=false,Q,P;for(P=0;P<this.hooks.length;P++){Q=this.hooks[P];if(Q[0]==S&&Q[1]==R){T=true}}if(!T){this.hooks.push([S,R])}};y.jqplot.EventListenerManager.prototype.add=function(Q,P){this.hooks.push([Q,P])};function D(){this.data=[];this.dataRenderer;this.dataRendererOptions;this.noDataIndicator={show:false,indicator:"Loading Data...",axes:{xaxis:{min:0,max:10,tickInterval:2,show:true},yaxis:{min:0,max:12,tickInterval:3,show:true}}};this.targetId=null;this.target=null;this.defaults={axesDefaults:{},axes:{xaxis:{},yaxis:{},x2axis:{},y2axis:{},y3axis:{},y4axis:{},y5axis:{},y6axis:{},y7axis:{},y8axis:{},y9axis:{}},seriesDefaults:{},series:[]};this.series=[];this.axes={xaxis:new n("xaxis"),yaxis:new n("yaxis"),x2axis:new n("x2axis"),y2axis:new n("y2axis"),y3axis:new n("y3axis"),y4axis:new n("y4axis"),y5axis:new n("y5axis"),y6axis:new n("y6axis"),y7axis:new n("y7axis"),y8axis:new n("y8axis"),y9axis:new n("y9axis")};this.grid=new z();this.legend=new g();this.baseCanvas=new y.jqplot.GenericCanvas();this.seriesStack=[];this.previousSeriesStack=[];this.eventCanvas=new y.jqplot.GenericCanvas();this._width=null;this._height=null;this._plotDimensions={height:null,width:null};this._gridPadding={top:null,right:null,bottom:null,left:null};this._defaultGridPadding={top:10,right:10,bottom:23,left:10};this.syncXTicks=true;this.syncYTicks=true;this.seriesColors=["#4bb2c5","#EAA228","#c5b47f","#579575","#839557","#958c12","#953579","#4b5de4","#d8b83f","#ff5800","#0085cc","#c747a3","#cddf54","#FBD178","#26B4E3","#bd70c7"];this.negativeSeriesColors=["#498991","#C08840","#9F9274","#546D61","#646C4A","#6F6621","#6E3F5F","#4F64B0","#A89050","#C45923","#187399","#945381","#959E5C","#C7AF7B","#478396","#907294"];this.sortData=true;var R=0;this.textColor;this.fontFamily;this.fontSize;this.title=new o();this.options={};this.stackSeries=false;this.defaultAxisStart=1;this._stackData=[];this._plotData=[];this.plugins={};this._drawCount=0;this.drawIfHidden=false;this.captureRightClick=false;this.themeEngine=new y.jqplot.ThemeEngine();this._sumy=0;this._sumx=0;this.preInitHooks=new y.jqplot.HooksManager();this.postInitHooks=new y.jqplot.HooksManager();this.preParseOptionsHooks=new y.jqplot.HooksManager();this.postParseOptionsHooks=new y.jqplot.HooksManager();this.preDrawHooks=new y.jqplot.HooksManager();this.postDrawHooks=new y.jqplot.HooksManager();this.preDrawSeriesHooks=new y.jqplot.HooksManager();this.postDrawSeriesHooks=new y.jqplot.HooksManager();this.preDrawLegendHooks=new y.jqplot.HooksManager();this.addLegendRowHooks=new y.jqplot.HooksManager();this.preSeriesInitHooks=new y.jqplot.HooksManager();this.postSeriesInitHooks=new y.jqplot.HooksManager();this.preParseSeriesOptionsHooks=new y.jqplot.HooksManager();this.postParseSeriesOptionsHooks=new y.jqplot.HooksManager();this.eventListenerHooks=new y.jqplot.EventListenerManager();this.preDrawSeriesShadowHooks=new y.jqplot.HooksManager();this.postDrawSeriesShadowHooks=new y.jqplot.HooksManager();this.colorGenerator=y.jqplot.ColorGenerator;this.init=function(aa,Z,W){W=W||{};for(var X=0;X<y.jqplot.preInitHooks.length;X++){y.jqplot.preInitHooks[X].call(this,aa,Z,W)}for(var X=0;X<this.preInitHooks.hooks.length;X++){this.preInitHooks.hooks[X].call(this,aa,Z,W)}this.targetId="#"+aa;this.target=y("#"+aa);this.target.removeClass("jqplot-error");if(!this.target.get(0)){throw"No plot target specified"}if(this.target.css("position")=="static"){this.target.css("position","relative")}if(!this.target.hasClass("jqplot-target")){this.target.addClass("jqplot-target")}if(!this.target.height()){var Y;if(W&&W.height){Y=parseInt(W.height,10)}else{if(this.target.attr("data-height")){Y=parseInt(this.target.attr("data-height"),10)}else{Y=parseInt(y.jqplot.config.defaultHeight,10)}}this._height=Y;this.target.css("height",Y+"px")}else{this._height=Y=this.target.height()}if(!this.target.width()){var T;if(W&&W.width){T=parseInt(W.width,10)}else{if(this.target.attr("data-width")){T=parseInt(this.target.attr("data-width"),10)}else{T=parseInt(y.jqplot.config.defaultWidth,10)}}this._width=T;this.target.css("width",T+"px")}else{this._width=T=this.target.width()}this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;if(this._height<=0||this._width<=0||!this._height||!this._width){throw"Canvas dimension not set"}if(W.dataRenderer&&jQuery.isFunction(W.dataRenderer)){if(W.dataRendererOptions){this.dataRendererOptions=W.dataRendererOptions}this.dataRenderer=W.dataRenderer;Z=this.dataRenderer(Z,this,this.dataRendererOptions)}if(W.noDataIndicator&&jQuery.isPlainObject(W.noDataIndicator)){y.extend(true,this.noDataIndicator,W.noDataIndicator)}if(Z==null){throw {name:"DataError",message:"No data to plot."}}if(jQuery.isArray(Z)==false||Z.length==0||jQuery.isArray(Z[0])==false||Z[0].length==0){if(this.noDataIndicator.show==false){throw {name:"DataError",message:"No data to plot."}}else{for(ax in this.noDataIndicator.axes){for(prop in this.noDataIndicator.axes[ax]){this.axes[ax][prop]=this.noDataIndicator.axes[ax][prop]}}this.postDrawHooks.add(function(){var af=this.eventCanvas.getHeight();var ad=this.eventCanvas.getWidth();var ac=y('<div class="jqplot-noData-container" style="position:absolute;"></div>');this.target.append(ac);ac.height(af);ac.width(ad);ac.css("top",this.eventCanvas._offsets.top);ac.css("left",this.eventCanvas._offsets.left);temp2=y('<div class="jqplot-noData-contents" style="text-align:center; position:relative; margin-left:auto; margin-right:auto;"></div>');ac.append(temp2);temp2.html(this.noDataIndicator.indicator);var ae=temp2.height();var ab=temp2.width();temp2.height(ae);temp2.width(ab);temp2.css("top",(af-ae)/2+"px")})}}this.data=Z;this.parseOptions(W);if(this.textColor){this.target.css("color",this.textColor)}if(this.fontFamily){this.target.css("font-family",this.fontFamily)}if(this.fontSize){this.target.css("font-size",this.fontSize)}this.title.init();this.legend.init();this._sumy=0;this._sumx=0;for(var X=0;X<this.series.length;X++){this.seriesStack.push(X);this.previousSeriesStack.push(X);this.series[X].shadowCanvas._plotDimensions=this._plotDimensions;this.series[X].canvas._plotDimensions=this._plotDimensions;for(var V=0;V<y.jqplot.preSeriesInitHooks.length;V++){y.jqplot.preSeriesInitHooks[V].call(this.series[X],aa,Z,this.options.seriesDefaults,this.options.series[X],this)}for(var V=0;V<this.preSeriesInitHooks.hooks.length;V++){this.preSeriesInitHooks.hooks[V].call(this.series[X],aa,Z,this.options.seriesDefaults,this.options.series[X],this)}this.populatePlotData(this.series[X],X);this.series[X]._plotDimensions=this._plotDimensions;this.series[X].init(X,this.grid.borderWidth,this);for(var V=0;V<y.jqplot.postSeriesInitHooks.length;V++){y.jqplot.postSeriesInitHooks[V].call(this.series[X],aa,Z,this.options.seriesDefaults,this.options.series[X],this)}for(var V=0;V<this.postSeriesInitHooks.hooks.length;V++){this.postSeriesInitHooks.hooks[V].call(this.series[X],aa,Z,this.options.seriesDefaults,this.options.series[X],this)}this._sumy+=this.series[X]._sumy;this._sumx+=this.series[X]._sumx}for(var U in this.axes){this.axes[U]._plotDimensions=this._plotDimensions;this.axes[U].init()}if(this.sortData){P(this.series)}this.grid.init();this.grid._axes=this.axes;this.legend._series=this.series;for(var X=0;X<y.jqplot.postInitHooks.length;X++){y.jqplot.postInitHooks[X].call(this,aa,Z,W)}for(var X=0;X<this.postInitHooks.hooks.length;X++){this.postInitHooks.hooks[X].call(this,aa,Z,W)}};this.resetAxesScale=function(Y,U){var W=U||{};var X=Y||this.axes;if(X===true){X=this.axes}if(jQuery.isArray(X)){for(var V=0;V<X.length;V++){this.axes[X[V]].resetScale(W[X[V]])}}else{if(typeof(X)==="object"){for(var T in X){this.axes[T].resetScale(W[T])}}}};this.reInitialize=function(){if(!this.target.height()){var W;if(options&&options.height){W=parseInt(options.height,10)}else{if(this.target.attr("data-height")){W=parseInt(this.target.attr("data-height"),10)}else{W=parseInt(y.jqplot.config.defaultHeight,10)}}this._height=W;this.target.css("height",W+"px")}else{this._height=this.target.height()}if(!this.target.width()){var T;if(options&&options.width){T=parseInt(options.width,10)}else{if(this.target.attr("data-width")){T=parseInt(this.target.attr("data-width"),10)}else{T=parseInt(y.jqplot.config.defaultWidth,10)}}this._width=T;this.target.css("width",T+"px")}else{this._width=this.target.width()}if(this._height<=0||this._width<=0||!this._height||!this._width){throw"Target dimension not set"}this._plotDimensions.height=this._height;this._plotDimensions.width=this._width;this.grid._plotDimensions=this._plotDimensions;this.title._plotDimensions=this._plotDimensions;this.baseCanvas._plotDimensions=this._plotDimensions;this.eventCanvas._plotDimensions=this._plotDimensions;this.legend._plotDimensions=this._plotDimensions;for(var X in this.axes){this.axes[X]._plotWidth=this._width;this.axes[X]._plotHeight=this._height}this.title._plotWidth=this._width;if(this.textColor){this.target.css("color",this.textColor)}if(this.fontFamily){this.target.css("font-family",this.fontFamily)}if(this.fontSize){this.target.css("font-size",this.fontSize)}this._sumy=0;this._sumx=0;for(var V=0;V<this.series.length;V++){this.populatePlotData(this.series[V],V);this.series[V]._plotDimensions=this._plotDimensions;this.series[V].canvas._plotDimensions=this._plotDimensions;this._sumy+=this.series[V]._sumy;this._sumx+=this.series[V]._sumx}for(var U in this.axes){this.axes[U]._plotDimensions=this._plotDimensions;this.axes[U]._ticks=[];this.axes[U].renderer.init.call(this.axes[U],{})}if(this.sortData){P(this.series)}this.grid._axes=this.axes;this.legend._series=this.series};function P(X){var ab,ac,ad,T,aa;for(var Y=0;Y<X.length;Y++){var U;var Z=[X[Y].data,X[Y]._stackData,X[Y]._plotData,X[Y]._prevPlotData];for(var V=0;V<4;V++){U=true;ab=Z[V];if(X[Y]._stackAxis=="x"){for(var W=0;W<ab.length;W++){if(typeof(ab[W][1])!="number"){U=false;break}}if(U){ab.sort(function(af,ae){return af[1]-ae[1]})}}else{for(var W=0;W<ab.length;W++){if(typeof(ab[W][0])!="number"){U=false;break}}if(U){ab.sort(function(af,ae){return af[0]-ae[0]})}}}}}this.populatePlotData=function(X,Y){this._plotData=[];this._stackData=[];X._stackData=[];X._plotData=[];var ab={x:[],y:[]};if(this.stackSeries&&!X.disableStack){X._stack=true;var Z=X._stackAxis=="x"?0:1;var aa=Z?0:1;var ac=y.extend(true,[],X.data);var ad=y.extend(true,[],X.data);for(var V=0;V<Y;V++){var T=this.series[V].data;for(var U=0;U<T.length;U++){ac[U][0]+=T[U][0];ac[U][1]+=T[U][1];ad[U][Z]+=T[U][Z]}}for(var W=0;W<ad.length;W++){ab.x.push(ad[W][0]);ab.y.push(ad[W][1])}this._plotData.push(ad);this._stackData.push(ac);X._stackData=ac;X._plotData=ad;X._plotValues=ab}else{for(var W=0;W<X.data.length;W++){ab.x.push(X.data[W][0]);ab.y.push(X.data[W][1])}this._stackData.push(X.data);this.series[Y]._stackData=X.data;this._plotData.push(X.data);X._plotData=X.data;X._plotValues=ab}if(Y>0){X._prevPlotData=this.series[Y-1]._plotData}X._sumy=0;X._sumx=0;for(W=X.data.length-1;W>-1;W--){X._sumy+=X.data[W][1];X._sumx+=X.data[W][0]}};this.getNextSeriesColor=(function(U){var T=0;var V=U.seriesColors;return function(){if(T<V.length){return V[T++]}else{T=0;return V[T++]}}})(this);this.parseOptions=function(ab){for(var Y=0;Y<this.preParseOptionsHooks.hooks.length;Y++){this.preParseOptionsHooks.hooks[Y].call(this,ab)}for(var Y=0;Y<y.jqplot.preParseOptionsHooks.length;Y++){y.jqplot.preParseOptionsHooks[Y].call(this,ab)}this.options=y.extend(true,{},this.defaults,ab);this.stackSeries=this.options.stackSeries;if(this.options.seriesColors){this.seriesColors=this.options.seriesColors}if(this.options.negativeSeriesColors){this.negativeSeriesColors=this.options.negativeSeriesColors}if(this.options.captureRightClick){this.captureRightClick=this.options.captureRightClick}this.defaultAxisStart=(ab&&ab.defaultAxisStart!=null)?ab.defaultAxisStart:this.defaultAxisStart;var T=new this.colorGenerator(this.seriesColors);y.extend(true,this._gridPadding,this.options.gridPadding);this.sortData=(this.options.sortData!=null)?this.options.sortData:this.sortData;for(var U in this.axes){var W=this.axes[U];y.extend(true,W,this.options.axesDefaults,this.options.axes[U]);W._plotWidth=this._width;W._plotHeight=this._height}if(this.data.length==0){this.data=[];for(var Y=0;Y<this.options.series.length;Y++){this.data.push(this.options.series.data)}}var Z=function(af,ad,ag){var ac=[];var ae;ad=ad||"vertical";if(!jQuery.isArray(af[0])){for(ae=0;ae<af.length;ae++){if(ad=="vertical"){ac.push([ag+ae,af[ae]])}else{ac.push([af[ae],ag+ae])}}}else{y.extend(true,ac,af)}return ac};for(var Y=0;Y<this.data.length;Y++){var aa=new E();for(var X=0;X<y.jqplot.preParseSeriesOptionsHooks.length;X++){y.jqplot.preParseSeriesOptionsHooks[X].call(aa,this.options.seriesDefaults,this.options.series[Y])}for(var X=0;X<this.preParseSeriesOptionsHooks.hooks.length;X++){this.preParseSeriesOptionsHooks.hooks[X].call(aa,this.options.seriesDefaults,this.options.series[Y])}y.extend(true,aa,{seriesColors:this.seriesColors,negativeSeriesColors:this.negativeSeriesColors},this.options.seriesDefaults,this.options.series[Y]);var V="vertical";if(aa.renderer.constructor==y.jqplot.barRenderer&&aa.rendererOptions&&aa.rendererOptions.barDirection=="horizontal"){V="horizontal"}aa.data=Z(this.data[Y],V,this.defaultAxisStart);switch(aa.xaxis){case"xaxis":aa._xaxis=this.axes.xaxis;break;case"x2axis":aa._xaxis=this.axes.x2axis;break;default:break}aa._yaxis=this.axes[aa.yaxis];aa._xaxis._series.push(aa);aa._yaxis._series.push(aa);if(aa.show){aa._xaxis.show=true;aa._yaxis.show=true}if(!aa.color&&aa.show!=false){aa.color=T.next()}if(!aa.label){aa.label="Series "+(Y+1).toString()}this.series.push(aa);for(var X=0;X<y.jqplot.postParseSeriesOptionsHooks.length;X++){y.jqplot.postParseSeriesOptionsHooks[X].call(this.series[Y],this.options.seriesDefaults,this.options.series[Y])}for(var X=0;X<this.postParseSeriesOptionsHooks.hooks.length;X++){this.postParseSeriesOptionsHooks.hooks[X].call(this.series[Y],this.options.seriesDefaults,this.options.series[Y])}}y.extend(true,this.grid,this.options.grid);for(var U in this.axes){var W=this.axes[U];if(W.borderWidth==null){W.borderWidth=this.grid.borderWidth}if(W.borderColor==null){if(U!="xaxis"&&U!="x2axis"&&W.useSeriesColor===true&&W.show){W.borderColor=W._series[0].color}else{W.borderColor=this.grid.borderColor}}}if(typeof this.options.title=="string"){this.title.text=this.options.title}else{if(typeof this.options.title=="object"){y.extend(true,this.title,this.options.title)}}this.title._plotWidth=this._width;this.legend.setOptions(this.options.legend);for(var Y=0;Y<y.jqplot.postParseOptionsHooks.length;Y++){y.jqplot.postParseOptionsHooks[Y].call(this,ab)}for(var Y=0;Y<this.postParseOptionsHooks.hooks.length;Y++){this.postParseOptionsHooks.hooks[Y].call(this,ab)}};this.replot=function(U){var V=U||{};var T=V.clear||true;var W=V.resetAxes||false;this.target.trigger("jqplotPreReplot");if(T){this.target.empty()}if(W){this.resetAxesScale(W,V.axes)}this.reInitialize();this.draw();this.target.trigger("jqplotPostReplot")};this.redraw=function(T){T=(T!=null)?T:true;this.target.trigger("jqplotPreRedraw");if(T){this.target.empty()}for(var V in this.axes){this.axes[V]._ticks=[]}for(var U=0;U<this.series.length;U++){this.populatePlotData(this.series[U],U)}this._sumy=0;this._sumx=0;for(U=0;U<this.series.length;U++){this._sumy+=this.series[U]._sumy;this._sumx+=this.series[U]._sumx}this.draw();this.target.trigger("jqplotPostRedraw")};this.draw=function(){if(this.drawIfHidden||this.target.is(":visible")){this.target.trigger("jqplotPreDraw");var Z,Y;for(Z=0;Z<y.jqplot.preDrawHooks.length;Z++){y.jqplot.preDrawHooks[Z].call(this)}for(Z=0;Z<this.preDrawHooks.hooks.length;Z++){this.preDrawHooks.hooks[Z].call(this)}this.target.append(this.baseCanvas.createElement({left:0,right:0,top:0,bottom:0},"jqplot-base-canvas"));this.baseCanvas.setContext();this.target.append(this.title.draw());this.title.pack({top:0,left:0});var ae=this.legend.draw();var ad={top:0,left:0,bottom:0,right:0};if(this.legend.placement=="outsideGrid"){this.target.append(ae);switch(this.legend.location){case"n":ad.top+=this.legend.getHeight();break;case"s":ad.bottom+=this.legend.getHeight();break;case"ne":case"e":case"se":ad.right+=this.legend.getWidth();break;case"nw":case"w":case"sw":ad.left+=this.legend.getWidth();break;default:ad.right+=this.legend.getWidth();break}ae=ae.detach()}var T=this.axes;for(var V in T){this.target.append(T[V].draw(this.baseCanvas._ctx));T[V].set()}if(T.yaxis.show){ad.left+=T.yaxis.getWidth()}var W=["y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];var U=[0,0,0,0,0,0,0,0];var ab=0;var X;for(X=0;X<8;X++){if(T[W[X]].show){ab+=T[W[X]].getWidth();U[X]=ab}}ad.right+=ab;if(T.x2axis.show){ad.top+=T.x2axis.getHeight()}if(this.title.show){ad.top+=this.title.getHeight()}if(T.xaxis.show){ad.bottom+=T.xaxis.getHeight()}var aa=["top","bottom","left","right"];for(var X in aa){if(this._gridPadding[aa[X]]==null&&ad[aa[X]]>0){this._gridPadding[aa[X]]=ad[aa[X]]}else{if(this._gridPadding[aa[X]]==null){this._gridPadding[aa[X]]=this._defaultGridPadding[aa[X]]}}}var ac=(this.legend.placement=="outsideGrid")?{top:this.title.getHeight(),left:0,right:0,bottom:0}:this._gridPadding;T.xaxis.pack({position:"absolute",bottom:this._gridPadding.bottom-T.xaxis.getHeight(),left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});T.yaxis.pack({position:"absolute",top:0,left:this._gridPadding.left-T.yaxis.getWidth(),height:this._height},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top});T.x2axis.pack({position:"absolute",top:this._gridPadding.top-T.x2axis.getHeight(),left:0,width:this._width},{min:this._gridPadding.left,max:this._width-this._gridPadding.right});for(Z=8;Z>0;Z--){T[W[Z-1]].pack({position:"absolute",top:0,right:this._gridPadding.right-U[Z-1]},{min:this._height-this._gridPadding.bottom,max:this._gridPadding.top})}this.target.append(this.grid.createElement(this._gridPadding));this.grid.draw();for(Z=0;Z<this.series.length;Z++){Y=this.seriesStack[Z];this.target.append(this.series[Y].shadowCanvas.createElement(this._gridPadding,"jqplot-series-shadowCanvas"));this.series[Y].shadowCanvas.setContext();this.series[Y].shadowCanvas._elem.data("seriesIndex",Y)}for(Z=0;Z<this.series.length;Z++){Y=this.seriesStack[Z];this.target.append(this.series[Y].canvas.createElement(this._gridPadding,"jqplot-series-canvas"));this.series[Y].canvas.setContext();this.series[Y].canvas._elem.data("seriesIndex",Y)}this.target.append(this.eventCanvas.createElement(this._gridPadding,"jqplot-event-canvas"));this.eventCanvas.setContext();this.eventCanvas._ctx.fillStyle="rgba(0,0,0,0)";this.eventCanvas._ctx.fillRect(0,0,this.eventCanvas._ctx.canvas.width,this.eventCanvas._ctx.canvas.height);this.bindCustomEvents();if(this.legend.preDraw){this.eventCanvas._elem.before(ae);this.legend.pack(ac);if(this.legend._elem){this.drawSeries({legendInfo:{location:this.legend.location,placement:this.legend.placement,width:this.legend.getWidth(),height:this.legend.getHeight(),xoffset:this.legend.xoffset,yoffset:this.legend.yoffset}})}else{this.drawSeries()}}else{this.drawSeries();if(this.series.length){y(this.series[this.series.length-1].canvas._elem).after(ae)}this.legend.pack(ac)}for(var Z=0;Z<y.jqplot.eventListenerHooks.length;Z++){this.eventCanvas._elem.bind(y.jqplot.eventListenerHooks[Z][0],{plot:this},y.jqplot.eventListenerHooks[Z][1])}for(var Z=0;Z<this.eventListenerHooks.hooks.length;Z++){this.eventCanvas._elem.bind(this.eventListenerHooks.hooks[Z][0],{plot:this},this.eventListenerHooks.hooks[Z][1])}for(var Z=0;Z<y.jqplot.postDrawHooks.length;Z++){y.jqplot.postDrawHooks[Z].call(this)}for(var Z=0;Z<this.postDrawHooks.hooks.length;Z++){this.postDrawHooks.hooks[Z].call(this)}if(this.target.is(":visible")){this._drawCount+=1}this.target.trigger("jqplotPostDraw",[this])}};this.bindCustomEvents=function(){this.eventCanvas._elem.bind("click",{plot:this},this.onClick);this.eventCanvas._elem.bind("dblclick",{plot:this},this.onDblClick);this.eventCanvas._elem.bind("mousedown",{plot:this},this.onMouseDown);this.eventCanvas._elem.bind("mousemove",{plot:this},this.onMouseMove);this.eventCanvas._elem.bind("mouseenter",{plot:this},this.onMouseEnter);this.eventCanvas._elem.bind("mouseleave",{plot:this},this.onMouseLeave);if(this.captureRightClick){this.eventCanvas._elem.bind("mouseup",{plot:this},this.onRightClick);this.eventCanvas._elem.get(0).oncontextmenu=function(){return false}}else{this.eventCanvas._elem.bind("mouseup",{plot:this},this.onMouseUp)}};function Q(ab){var aa=ab.data.plot;var W=aa.eventCanvas._elem.offset();var Z={x:ab.pageX-W.left,y:ab.pageY-W.top};var X={xaxis:null,yaxis:null,x2axis:null,y2axis:null,y3axis:null,y4axis:null,y5axis:null,y6axis:null,y7axis:null,y8axis:null,y9axis:null};var Y=["xaxis","yaxis","x2axis","y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];var T=aa.axes;var U,V;for(U=11;U>0;U--){V=Y[U-1];if(T[V].show){X[V]=T[V].series_p2u(Z[V.charAt(0)])}}return{offsets:W,gridPos:Z,dataPos:X}}function S(T,U){var Y=U.series;var aD,aC,aB,av,aw,ap,ao,ad,ab,af,ag,aq;var aA,aE,ay,Z,an,at;var V,au;for(aB=U.seriesStack.length-1;aB>=0;aB--){aD=U.seriesStack[aB];av=Y[aD];switch(av.renderer.constructor){case y.jqplot.BarRenderer:ap=T.x;ao=T.y;for(aC=0;aC<av._barPoints.length;aC++){an=av._barPoints[aC];if(ap>an[0][0]&&ap<an[2][0]&&ao>an[2][1]&&ao<an[0][1]){return{seriesIndex:av.index,pointIndex:aC,gridData:ay,data:av.data[aC],points:av._barPoints[aC]}}}break;case y.jqplot.DonutRenderer:af=av.startAngle/180*Math.PI;ap=T.x-av._center[0];ao=T.y-av._center[1];aw=Math.sqrt(Math.pow(ap,2)+Math.pow(ao,2));if(ap>0&&-ao>=0){ad=2*Math.PI-Math.atan(-ao/ap)}else{if(ap>0&&-ao<0){ad=-Math.atan(-ao/ap)}else{if(ap<0){ad=Math.PI-Math.atan(-ao/ap)}else{if(ap==0&&-ao>0){ad=3*Math.PI/2}else{if(ap==0&&-ao<0){ad=Math.PI/2}else{if(ap==0&&ao==0){ad=0}}}}}}if(af){ad-=af;if(ad<0){ad+=2*Math.PI}else{if(ad>2*Math.PI){ad-=2*Math.PI}}}ab=av.sliceMargin/180*Math.PI;if(aw<av._radius&&aw>av._innerRadius){for(aC=0;aC<av.gridData.length;aC++){ag=(aC>0)?av.gridData[aC-1][1]+ab:ab;aq=av.gridData[aC][1];if(ad>ag&&ad<aq){return{seriesIndex:av.index,pointIndex:aC,gridData:av.gridData[aC],data:av.data[aC]}}}}break;case y.jqplot.PieRenderer:af=av.startAngle/180*Math.PI;ap=T.x-av._center[0];ao=T.y-av._center[1];aw=Math.sqrt(Math.pow(ap,2)+Math.pow(ao,2));if(ap>0&&-ao>=0){ad=2*Math.PI-Math.atan(-ao/ap)}else{if(ap>0&&-ao<0){ad=-Math.atan(-ao/ap)}else{if(ap<0){ad=Math.PI-Math.atan(-ao/ap)}else{if(ap==0&&-ao>0){ad=3*Math.PI/2}else{if(ap==0&&-ao<0){ad=Math.PI/2}else{if(ap==0&&ao==0){ad=0}}}}}}if(af){ad-=af;if(ad<0){ad+=2*Math.PI}else{if(ad>2*Math.PI){ad-=2*Math.PI}}}ab=av.sliceMargin/180*Math.PI;if(aw<av._radius){for(aC=0;aC<av.gridData.length;aC++){ag=(aC>0)?av.gridData[aC-1][1]+ab:ab;aq=av.gridData[aC][1];if(ad>ag&&ad<aq){return{seriesIndex:av.index,pointIndex:aC,gridData:av.gridData[aC],data:av.data[aC]}}}}break;case y.jqplot.BubbleRenderer:ap=T.x;ao=T.y;var al=null;if(av.show){for(var aC=0;aC<av.gridData.length;aC++){ay=av.gridData[aC];aE=Math.sqrt((ap-ay[0])*(ap-ay[0])+(ao-ay[1])*(ao-ay[1]));if(aE<=ay[2]&&(aE<=aA||aA==null)){aA=aE;al={seriesIndex:aD,pointIndex:aC,gridData:ay,data:av.data[aC]}}}if(al!=null){return al}}break;case y.jqplot.FunnelRenderer:ap=T.x;ao=T.y;var ar=av._vertices,X=ar[0],W=ar[ar.length-1],aa,ak;function az(aH,aJ,aI){var aG=(aJ[1]-aI[1])/(aJ[0]-aI[0]);var aF=aJ[1]-aG*aJ[0];var aK=aH+aJ[1];return[(aK-aF)/aG,aK]}aa=az(ao,X[0],W[3]);ak=az(ao,X[1],W[2]);for(aC=0;aC<ar.length;aC++){cv=ar[aC];if(ao>=cv[0][1]&&ao<=cv[3][1]&&ap>=aa[0]&&ap<=ak[0]){return{seriesIndex:av.index,pointIndex:aC,gridData:null,data:av.data[aC]}}}break;case y.jqplot.LineRenderer:ap=T.x;ao=T.y;aw=av.renderer;if(av.show){if(av.fill){var ae=false;if(ap>av._boundingBox[0][0]&&ap<av._boundingBox[1][0]&&ao>av._boundingBox[1][1]&&ao<av._boundingBox[0][1]){var aj=av._areaPoints.length;var am;var aC=aj-1;for(var am=0;am<aj;am++){var ai=[av._areaPoints[am][0],av._areaPoints[am][1]];var ah=[av._areaPoints[aC][0],av._areaPoints[aC][1]];if(ai[1]<ao&&ah[1]>=ao||ah[1]<ao&&ai[1]>=ao){if(ai[0]+(ao-ai[1])/(ah[1]-ai[1])*(ah[0]-ai[0])<ap){ae=!ae}}aC=am}}if(ae){return{seriesIndex:aD,pointIndex:null,gridData:av.gridData,data:av.data,points:av._areaPoints}}break}else{au=av.markerRenderer.size/2+av.neighborThreshold;V=(au>0)?au:0;for(var aC=0;aC<av.gridData.length;aC++){ay=av.gridData[aC];if(aw.constructor==y.jqplot.OHLCRenderer){if(aw.candleStick){var ac=av._yaxis.series_u2p;if(ap>=ay[0]-aw._bodyWidth/2&&ap<=ay[0]+aw._bodyWidth/2&&ao>=ac(av.data[aC][2])&&ao<=ac(av.data[aC][3])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:av.data[aC]}}}else{if(!aw.hlc){var ac=av._yaxis.series_u2p;if(ap>=ay[0]-aw._tickLength&&ap<=ay[0]+aw._tickLength&&ao>=ac(av.data[aC][2])&&ao<=ac(av.data[aC][3])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:av.data[aC]}}}else{var ac=av._yaxis.series_u2p;if(ap>=ay[0]-aw._tickLength&&ap<=ay[0]+aw._tickLength&&ao>=ac(av.data[aC][1])&&ao<=ac(av.data[aC][2])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:av.data[aC]}}}}}else{if(ay[0]!=null&&ay[1]!=null){aE=Math.sqrt((ap-ay[0])*(ap-ay[0])+(ao-ay[1])*(ao-ay[1]));if(aE<=V&&(aE<=aA||aA==null)){aA=aE;return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:av.data[aC]}}}}}}}break;default:ap=T.x;ao=T.y;aw=av.renderer;if(av.show){au=av.markerRenderer.size/2+av.neighborThreshold;V=(au>0)?au:0;for(var aC=0;aC<av.gridData.length;aC++){ay=av.gridData[aC];if(aw.constructor==y.jqplot.OHLCRenderer){if(aw.candleStick){var ac=av._yaxis.series_u2p;if(ap>=ay[0]-aw._bodyWidth/2&&ap<=ay[0]+aw._bodyWidth/2&&ao>=ac(av.data[aC][2])&&ao<=ac(av.data[aC][3])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:av.data[aC]}}}else{if(!aw.hlc){var ac=av._yaxis.series_u2p;if(ap>=ay[0]-aw._tickLength&&ap<=ay[0]+aw._tickLength&&ao>=ac(av.data[aC][2])&&ao<=ac(av.data[aC][3])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:av.data[aC]}}}else{var ac=av._yaxis.series_u2p;if(ap>=ay[0]-aw._tickLength&&ap<=ay[0]+aw._tickLength&&ao>=ac(av.data[aC][1])&&ao<=ac(av.data[aC][2])){return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:av.data[aC]}}}}}else{aE=Math.sqrt((ap-ay[0])*(ap-ay[0])+(ao-ay[1])*(ao-ay[1]));if(aE<=V&&(aE<=aA||aA==null)){aA=aE;return{seriesIndex:aD,pointIndex:aC,gridData:ay,data:av.data[aC]}}}}}break}}return null}this.onClick=function(V){var U=Q(V);var X=V.data.plot;var W=S(U.gridPos,X);var T=jQuery.Event("jqplotClick");T.pageX=V.pageX;T.pageY=V.pageY;y(this).trigger(T,[U.gridPos,U.dataPos,W,X])};this.onDblClick=function(V){var U=Q(V);var X=V.data.plot;var W=S(U.gridPos,X);var T=jQuery.Event("jqplotDblClick");T.pageX=V.pageX;T.pageY=V.pageY;y(this).trigger(T,[U.gridPos,U.dataPos,W,X])};this.onMouseDown=function(V){var U=Q(V);var X=V.data.plot;var W=S(U.gridPos,X);var T=jQuery.Event("jqplotMouseDown");T.pageX=V.pageX;T.pageY=V.pageY;y(this).trigger(T,[U.gridPos,U.dataPos,W,X])};this.onMouseUp=function(V){var U=Q(V);var T=jQuery.Event("jqplotMouseUp");T.pageX=V.pageX;T.pageY=V.pageY;y(this).trigger(T,[U.gridPos,U.dataPos,null,V.data.plot])};this.onRightClick=function(V){var U=Q(V);var X=V.data.plot;var W=S(U.gridPos,X);if(X.captureRightClick){if(V.which==3){var T=jQuery.Event("jqplotRightClick");T.pageX=V.pageX;T.pageY=V.pageY;y(this).trigger(T,[U.gridPos,U.dataPos,W,X])}else{var T=jQuery.Event("jqplotMouseUp");T.pageX=V.pageX;T.pageY=V.pageY;y(this).trigger(T,[U.gridPos,U.dataPos,W,X])}}};this.onMouseMove=function(V){var U=Q(V);var X=V.data.plot;var W=S(U.gridPos,X);var T=jQuery.Event("jqplotMouseMove");T.pageX=V.pageX;T.pageY=V.pageY;y(this).trigger(T,[U.gridPos,U.dataPos,W,X])};this.onMouseEnter=function(V){var U=Q(V);var W=V.data.plot;var T=jQuery.Event("jqplotMouseEnter");T.pageX=V.pageX;T.pageY=V.pageY;y(this).trigger(T,[U.gridPos,U.dataPos,null,W])};this.onMouseLeave=function(V){var U=Q(V);var W=V.data.plot;var T=jQuery.Event("jqplotMouseLeave");T.pageX=V.pageX;T.pageY=V.pageY;y(this).trigger(T,[U.gridPos,U.dataPos,null,W])};this.drawSeries=function(V,T){var X,W,U;T=(typeof(V)==="number"&&T==null)?V:T;V=(typeof(V)==="object")?V:{};if(T!=l){W=this.series[T];U=W.shadowCanvas._ctx;U.clearRect(0,0,U.canvas.width,U.canvas.height);W.drawShadow(U,V,this);U=W.canvas._ctx;U.clearRect(0,0,U.canvas.width,U.canvas.height);W.draw(U,V,this);if(W.renderer.constructor==y.jqplot.BezierCurveRenderer){if(T<this.series.length-1){this.drawSeries(T+1)}}}else{for(X=0;X<this.series.length;X++){W=this.series[X];U=W.shadowCanvas._ctx;U.clearRect(0,0,U.canvas.width,U.canvas.height);W.drawShadow(U,V,this);U=W.canvas._ctx;U.clearRect(0,0,U.canvas.width,U.canvas.height);W.draw(U,V,this)}}V=T=X=W=U=null};this.moveSeriesToFront=function(U){U=parseInt(U,10);var X=y.inArray(U,this.seriesStack);if(X==-1){return}if(X==this.seriesStack.length-1){this.previousSeriesStack=this.seriesStack.slice(0);return}var T=this.seriesStack[this.seriesStack.length-1];var W=this.series[U].canvas._elem.detach();var V=this.series[U].shadowCanvas._elem.detach();this.series[T].shadowCanvas._elem.after(V);this.series[T].canvas._elem.after(W);this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack.splice(X,1);this.seriesStack.push(U)};this.moveSeriesToBack=function(U){U=parseInt(U,10);var X=y.inArray(U,this.seriesStack);if(X==0||X==-1){return}var T=this.seriesStack[0];var W=this.series[U].canvas._elem.detach();var V=this.series[U].shadowCanvas._elem.detach();this.series[T].shadowCanvas._elem.before(V);this.series[T].canvas._elem.before(W);this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack.splice(X,1);this.seriesStack.unshift(U)};this.restorePreviousSeriesOrder=function(){var X,W,V,U,T;if(this.seriesStack==this.previousSeriesStack){return}for(X=1;X<this.previousSeriesStack.length;X++){move=this.previousSeriesStack[X];keep=this.previousSeriesStack[X-1];V=this.series[move].canvas._elem.detach();U=this.series[move].shadowCanvas._elem.detach();this.series[keep].shadowCanvas._elem.after(U);this.series[keep].canvas._elem.after(V)}T=this.seriesStack.slice(0);this.seriesStack=this.previousSeriesStack.slice(0);this.previousSeriesStack=T};this.restoreOriginalSeriesOrder=function(){var V,U,T=[];for(V=0;V<this.series.length;V++){T.push(V)}if(this.seriesStack==T){return}this.previousSeriesStack=this.seriesStack.slice(0);this.seriesStack=T;for(V=1;V<this.seriesStack.length;V++){serelem=this.series[V].canvas._elem.detach();shadelem=this.series[V].shadowCanvas._elem.detach();this.series[V-1].shadowCanvas._elem.after(shadelem);this.series[V-1].canvas._elem.after(serelem)}};this.activateTheme=function(T){this.themeEngine.activate(this,T)}}y.jqplot.computeHighlightColors=function(Q){var S;if(jQuery.isArray(Q)){S=[];for(var U=0;U<Q.length;U++){var T=y.jqplot.getColorComponents(Q[U]);var P=[T[0],T[1],T[2]];var V=P[0]+P[1]+P[2];for(var R=0;R<3;R++){P[R]=(V>570)?P[R]*0.8:P[R]+0.3*(255-P[R]);P[R]=parseInt(P[R],10)}S.push("rgb("+P[0]+","+P[1]+","+P[2]+")")}}else{var T=y.jqplot.getColorComponents(Q);var P=[T[0],T[1],T[2]];var V=P[0]+P[1]+P[2];for(var R=0;R<3;R++){P[R]=(V>570)?P[R]*0.8:P[R]+0.3*(255-P[R]);P[R]=parseInt(P[R],10)}S="rgb("+P[0]+","+P[1]+","+P[2]+")"}return S};y.jqplot.ColorGenerator=function(Q){var P=0;this.next=function(){if(P<Q.length){return Q[P++]}else{P=0;return Q[P++]}};this.previous=function(){if(P>0){return Q[P--]}else{P=Q.length-1;return Q[P]}};this.get=function(S){var R=S-Q.length*Math.floor(S/Q.length);return Q[R]};this.setColors=function(R){Q=R};this.reset=function(){P=0}};y.jqplot.hex2rgb=function(R,P){R=R.replace("#","");if(R.length==3){R=R.charAt(0)+R.charAt(0)+R.charAt(1)+R.charAt(1)+R.charAt(2)+R.charAt(2)}var Q;Q="rgba("+parseInt(R.slice(0,2),16)+", "+parseInt(R.slice(2,4),16)+", "+parseInt(R.slice(4,6),16);if(P){Q+=", "+P}Q+=")";return Q};y.jqplot.rgb2hex=function(T){var R=/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *(?:, *[0-9.]*)?\)/;var P=T.match(R);var S="#";for(i=1;i<4;i++){var Q;if(P[i].search(/%/)!=-1){Q=parseInt(255*P[i]/100,10).toString(16);if(Q.length==1){Q="0"+Q}}else{Q=parseInt(P[i],10).toString(16);if(Q.length==1){Q="0"+Q}}S+=Q}return S};y.jqplot.normalize2rgb=function(Q,P){if(Q.search(/^ *rgba?\(/)!=-1){return Q}else{if(Q.search(/^ *#?[0-9a-fA-F]?[0-9a-fA-F]/)!=-1){return y.jqplot.hex2rgb(Q,P)}else{throw"invalid color spec"}}};y.jqplot.getColorComponents=function(T){T=y.jqplot.colorKeywordMap[T]||T;var S=y.jqplot.normalize2rgb(T);var R=/rgba?\( *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *, *([0-9]{1,3}\.?[0-9]*%?) *,? *([0-9.]* *)?\)/;var P=S.match(R);var Q=[];for(i=1;i<4;i++){if(P[i].search(/%/)!=-1){Q[i-1]=parseInt(255*P[i]/100,10)}else{Q[i-1]=parseInt(P[i],10)}}Q[3]=parseFloat(P[4])?parseFloat(P[4]):1;return Q};y.jqplot.colorKeywordMap={aliceblue:"rgb(240, 248, 255)",antiquewhite:"rgb(250, 235, 215)",aqua:"rgb( 0, 255, 255)",aquamarine:"rgb(127, 255, 212)",azure:"rgb(240, 255, 255)",beige:"rgb(245, 245, 220)",bisque:"rgb(255, 228, 196)",black:"rgb( 0, 0, 0)",blanchedalmond:"rgb(255, 235, 205)",blue:"rgb( 0, 0, 255)",blueviolet:"rgb(138, 43, 226)",brown:"rgb(165, 42, 42)",burlywood:"rgb(222, 184, 135)",cadetblue:"rgb( 95, 158, 160)",chartreuse:"rgb(127, 255, 0)",chocolate:"rgb(210, 105, 30)",coral:"rgb(255, 127, 80)",cornflowerblue:"rgb(100, 149, 237)",cornsilk:"rgb(255, 248, 220)",crimson:"rgb(220, 20, 60)",cyan:"rgb( 0, 255, 255)",darkblue:"rgb( 0, 0, 139)",darkcyan:"rgb( 0, 139, 139)",darkgoldenrod:"rgb(184, 134, 11)",darkgray:"rgb(169, 169, 169)",darkgreen:"rgb( 0, 100, 0)",darkgrey:"rgb(169, 169, 169)",darkkhaki:"rgb(189, 183, 107)",darkmagenta:"rgb(139, 0, 139)",darkolivegreen:"rgb( 85, 107, 47)",darkorange:"rgb(255, 140, 0)",darkorchid:"rgb(153, 50, 204)",darkred:"rgb(139, 0, 0)",darksalmon:"rgb(233, 150, 122)",darkseagreen:"rgb(143, 188, 143)",darkslateblue:"rgb( 72, 61, 139)",darkslategray:"rgb( 47, 79, 79)",darkslategrey:"rgb( 47, 79, 79)",darkturquoise:"rgb( 0, 206, 209)",darkviolet:"rgb(148, 0, 211)",deeppink:"rgb(255, 20, 147)",deepskyblue:"rgb( 0, 191, 255)",dimgray:"rgb(105, 105, 105)",dimgrey:"rgb(105, 105, 105)",dodgerblue:"rgb( 30, 144, 255)",firebrick:"rgb(178, 34, 34)",floralwhite:"rgb(255, 250, 240)",forestgreen:"rgb( 34, 139, 34)",fuchsia:"rgb(255, 0, 255)",gainsboro:"rgb(220, 220, 220)",ghostwhite:"rgb(248, 248, 255)",gold:"rgb(255, 215, 0)",goldenrod:"rgb(218, 165, 32)",gray:"rgb(128, 128, 128)",grey:"rgb(128, 128, 128)",green:"rgb( 0, 128, 0)",greenyellow:"rgb(173, 255, 47)",honeydew:"rgb(240, 255, 240)",hotpink:"rgb(255, 105, 180)",indianred:"rgb(205, 92, 92)",indigo:"rgb( 75, 0, 130)",ivory:"rgb(255, 255, 240)",khaki:"rgb(240, 230, 140)",lavender:"rgb(230, 230, 250)",lavenderblush:"rgb(255, 240, 245)",lawngreen:"rgb(124, 252, 0)",lemonchiffon:"rgb(255, 250, 205)",lightblue:"rgb(173, 216, 230)",lightcoral:"rgb(240, 128, 128)",lightcyan:"rgb(224, 255, 255)",lightgoldenrodyellow:"rgb(250, 250, 210)",lightgray:"rgb(211, 211, 211)",lightgreen:"rgb(144, 238, 144)",lightgrey:"rgb(211, 211, 211)",lightpink:"rgb(255, 182, 193)",lightsalmon:"rgb(255, 160, 122)",lightseagreen:"rgb( 32, 178, 170)",lightskyblue:"rgb(135, 206, 250)",lightslategray:"rgb(119, 136, 153)",lightslategrey:"rgb(119, 136, 153)",lightsteelblue:"rgb(176, 196, 222)",lightyellow:"rgb(255, 255, 224)",lime:"rgb( 0, 255, 0)",limegreen:"rgb( 50, 205, 50)",linen:"rgb(250, 240, 230)",magenta:"rgb(255, 0, 255)",maroon:"rgb(128, 0, 0)",mediumaquamarine:"rgb(102, 205, 170)",mediumblue:"rgb( 0, 0, 205)",mediumorchid:"rgb(186, 85, 211)",mediumpurple:"rgb(147, 112, 219)",mediumseagreen:"rgb( 60, 179, 113)",mediumslateblue:"rgb(123, 104, 238)",mediumspringgreen:"rgb( 0, 250, 154)",mediumturquoise:"rgb( 72, 209, 204)",mediumvioletred:"rgb(199, 21, 133)",midnightblue:"rgb( 25, 25, 112)",mintcream:"rgb(245, 255, 250)",mistyrose:"rgb(255, 228, 225)",moccasin:"rgb(255, 228, 181)",navajowhite:"rgb(255, 222, 173)",navy:"rgb( 0, 0, 128)",oldlace:"rgb(253, 245, 230)",olive:"rgb(128, 128, 0)",olivedrab:"rgb(107, 142, 35)",orange:"rgb(255, 165, 0)",orangered:"rgb(255, 69, 0)",orchid:"rgb(218, 112, 214)",palegoldenrod:"rgb(238, 232, 170)",palegreen:"rgb(152, 251, 152)",paleturquoise:"rgb(175, 238, 238)",palevioletred:"rgb(219, 112, 147)",papayawhip:"rgb(255, 239, 213)",peachpuff:"rgb(255, 218, 185)",peru:"rgb(205, 133, 63)",pink:"rgb(255, 192, 203)",plum:"rgb(221, 160, 221)",powderblue:"rgb(176, 224, 230)",purple:"rgb(128, 0, 128)",red:"rgb(255, 0, 0)",rosybrown:"rgb(188, 143, 143)",royalblue:"rgb( 65, 105, 225)",saddlebrown:"rgb(139, 69, 19)",salmon:"rgb(250, 128, 114)",sandybrown:"rgb(244, 164, 96)",seagreen:"rgb( 46, 139, 87)",seashell:"rgb(255, 245, 238)",sienna:"rgb(160, 82, 45)",silver:"rgb(192, 192, 192)",skyblue:"rgb(135, 206, 235)",slateblue:"rgb(106, 90, 205)",slategray:"rgb(112, 128, 144)",slategrey:"rgb(112, 128, 144)",snow:"rgb(255, 250, 250)",springgreen:"rgb( 0, 255, 127)",steelblue:"rgb( 70, 130, 180)",tan:"rgb(210, 180, 140)",teal:"rgb( 0, 128, 128)",thistle:"rgb(216, 191, 216)",tomato:"rgb(255, 99, 71)",turquoise:"rgb( 64, 224, 208)",violet:"rgb(238, 130, 238)",wheat:"rgb(245, 222, 179)",white:"rgb(255, 255, 255)",whitesmoke:"rgb(245, 245, 245)",yellow:"rgb(255, 255, 0)",yellowgreen:"rgb(154, 205, 50)"};y.jqplot.AxisLabelRenderer=function(P){y.jqplot.ElemContainer.call(this);this.axis;this.show=true;this.label="";this.fontFamily=null;this.fontSize=null;this.textColor=null;this._elem;this.escapeHTML=false;y.extend(true,this,P)};y.jqplot.AxisLabelRenderer.prototype=new y.jqplot.ElemContainer();y.jqplot.AxisLabelRenderer.prototype.constructor=y.jqplot.AxisLabelRenderer;y.jqplot.AxisLabelRenderer.prototype.init=function(P){y.extend(true,this,P)};y.jqplot.AxisLabelRenderer.prototype.draw=function(){this._elem=y('<div style="position:absolute;" class="jqplot-'+this.axis+'-label"></div>');if(Number(this.label)){this._elem.css("white-space","nowrap")}if(!this.escapeHTML){this._elem.html(this.label)}else{this._elem.text(this.label)}if(this.fontFamily){this._elem.css("font-family",this.fontFamily)}if(this.fontSize){this._elem.css("font-size",this.fontSize)}if(this.textColor){this._elem.css("color",this.textColor)}return this._elem};y.jqplot.AxisLabelRenderer.prototype.pack=function(){};y.jqplot.AxisTickRenderer=function(P){y.jqplot.ElemContainer.call(this);this.mark="outside";this.axis;this.showMark=true;this.showGridline=true;this.isMinorTick=false;this.size=4;this.markSize=6;this.show=true;this.showLabel=true;this.label="";this.value=null;this._styles={};this.formatter=y.jqplot.DefaultTickFormatter;this.prefix="";this.formatString="";this.fontFamily;this.fontSize;this.textColor;this._elem;this._breakTick=false;y.extend(true,this,P)};y.jqplot.AxisTickRenderer.prototype.init=function(P){y.extend(true,this,P)};y.jqplot.AxisTickRenderer.prototype=new y.jqplot.ElemContainer();y.jqplot.AxisTickRenderer.prototype.constructor=y.jqplot.AxisTickRenderer;y.jqplot.AxisTickRenderer.prototype.setTick=function(P,R,Q){this.value=P;this.axis=R;if(Q){this.isMinorTick=true}return this};y.jqplot.AxisTickRenderer.prototype.draw=function(){if(!this.label){this.label=this.formatter(this.formatString,this.value)}if(this.prefix&&!this.formatString){this.label=this.prefix+this.label}style='style="position:absolute;';if(Number(this.label)){style+="white-space:nowrap;"}style+='"';this._elem=y("<div "+style+' class="jqplot-'+this.axis+'-tick">'+this.label+"</div>");for(var P in this._styles){this._elem.css(P,this._styles[P])}if(this.fontFamily){this._elem.css("font-family",this.fontFamily)}if(this.fontSize){this._elem.css("font-size",this.fontSize)}if(this.textColor){this._elem.css("color",this.textColor)}if(this._breakTick){this._elem.addClass("jqplot-breakTick")}return this._elem};y.jqplot.DefaultTickFormatter=function(P,Q){if(typeof Q=="number"){if(!P){P=y.jqplot.config.defaultTickFormatString}return y.jqplot.sprintf(P,Q)}else{return String(Q)}};y.jqplot.AxisTickRenderer.prototype.pack=function(){};y.jqplot.CanvasGridRenderer=function(){this.shadowRenderer=new y.jqplot.ShadowRenderer()};y.jqplot.CanvasGridRenderer.prototype.init=function(Q){this._ctx;y.extend(true,this,Q);var P={lineJoin:"miter",lineCap:"round",fill:false,isarc:false,angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.shadowWidth,closePath:false,strokeStyle:this.shadowColor};this.renderer.shadowRenderer.init(P)};y.jqplot.CanvasGridRenderer.prototype.createElement=function(){var R=document.createElement("canvas");var P=this._plotDimensions.width;var Q=this._plotDimensions.height;R.width=P;R.height=Q;this._elem=y(R);this._elem.addClass("jqplot-grid-canvas");this._elem.css({position:"absolute",left:0,top:0});if(y.jqplot.use_excanvas){window.G_vmlCanvasManager.init_(document)}if(y.jqplot.use_excanvas){R=window.G_vmlCanvasManager.initElement(R)}this._top=this._offsets.top;this._bottom=Q-this._offsets.bottom;this._left=this._offsets.left;this._right=P-this._offsets.right;this._width=this._right-this._left;this._height=this._bottom-this._top;R=null;return this._elem};y.jqplot.CanvasGridRenderer.prototype.draw=function(){this._ctx=this._elem.get(0).getContext("2d");var af=this._ctx;var Y=this._axes;af.save();af.clearRect(0,0,this._plotDimensions.width,this._plotDimensions.height);af.fillStyle=this.backgroundColor||this.background;af.fillRect(this._left,this._top,this._width,this._height);if(true){af.save();af.lineJoin="miter";af.lineCap="butt";af.lineWidth=this.gridLineWidth;af.strokeStyle=this.gridLineColor;var aa,X;var P=["xaxis","yaxis","x2axis","y2axis"];for(var U=4;U>0;U--){var Q=P[U-1];var S=Y[Q];var ab=S._ticks;if(S.show){for(var T=ab.length;T>0;T--){var ae=ab[T-1];if(ae.show){var Z=Math.round(S.u2p(ae.value))+0.5;switch(Q){case"xaxis":if(ae.showGridline&&this.drawGridlines){W(Z,this._top,Z,this._bottom)}if(ae.showMark&&ae.mark){s=ae.markSize;m=ae.mark;var Z=Math.round(S.u2p(ae.value))+0.5;switch(m){case"outside":aa=this._bottom;X=this._bottom+s;break;case"inside":aa=this._bottom-s;X=this._bottom;break;case"cross":aa=this._bottom-s;X=this._bottom+s;break;default:aa=this._bottom;X=this._bottom+s;break}if(this.shadow){this.renderer.shadowRenderer.draw(af,[[Z,aa],[Z,X]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false})}W(Z,aa,Z,X)}break;case"yaxis":if(ae.showGridline&&this.drawGridlines){W(this._right,Z,this._left,Z)}if(ae.showMark&&ae.mark){s=ae.markSize;m=ae.mark;var Z=Math.round(S.u2p(ae.value))+0.5;switch(m){case"outside":aa=this._left-s;X=this._left;break;case"inside":aa=this._left;X=this._left+s;break;case"cross":aa=this._left-s;X=this._left+s;break;default:aa=this._left-s;X=this._left;break}if(this.shadow){this.renderer.shadowRenderer.draw(af,[[aa,Z],[X,Z]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}W(aa,Z,X,Z,{strokeStyle:S.borderColor})}break;case"x2axis":if(ae.showGridline&&this.drawGridlines){W(Z,this._bottom,Z,this._top)}if(ae.showMark&&ae.mark){s=ae.markSize;m=ae.mark;var Z=Math.round(S.u2p(ae.value))+0.5;switch(m){case"outside":aa=this._top-s;X=this._top;break;case"inside":aa=this._top;X=this._top+s;break;case"cross":aa=this._top-s;X=this._top+s;break;default:aa=this._top-s;X=this._top;break}if(this.shadow){this.renderer.shadowRenderer.draw(af,[[Z,aa],[Z,X]],{lineCap:"butt",lineWidth:this.gridLineWidth,offset:this.gridLineWidth*0.75,depth:2,fill:false,closePath:false})}W(Z,aa,Z,X)}break;case"y2axis":if(ae.showGridline&&this.drawGridlines){W(this._left,Z,this._right,Z)}if(ae.showMark&&ae.mark){s=ae.markSize;m=ae.mark;var Z=Math.round(S.u2p(ae.value))+0.5;switch(m){case"outside":aa=this._right;X=this._right+s;break;case"inside":aa=this._right-s;X=this._right;break;case"cross":aa=this._right-s;X=this._right+s;break;default:aa=this._right;X=this._right+s;break}if(this.shadow){this.renderer.shadowRenderer.draw(af,[[aa,Z],[X,Z]],{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}W(aa,Z,X,Z,{strokeStyle:S.borderColor})}break;default:break}}}ae=null}S=null;ab=null}P=["y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];for(var U=7;U>0;U--){var S=Y[P[U-1]];var ab=S._ticks;if(S.show){var ad=ab[S.numberTicks-1];var V=ab[0];var R=S.getLeft();var ac=[[R,ad.getTop()+ad.getHeight()/2],[R,V.getTop()+V.getHeight()/2+1]];if(this.shadow){this.renderer.shadowRenderer.draw(af,ac,{lineCap:"butt",fill:false,closePath:false})}W(ac[0][0],ac[0][1],ac[1][0],ac[1][1],{lineCap:"butt",strokeStyle:S.borderColor,lineWidth:S.borderWidth});for(var T=ab.length;T>0;T--){var ae=ab[T-1];s=ae.markSize;m=ae.mark;var Z=Math.round(S.u2p(ae.value))+0.5;if(ae.showMark&&ae.mark){switch(m){case"outside":aa=R;X=R+s;break;case"inside":aa=R-s;X=R;break;case"cross":aa=R-s;X=R+s;break;default:aa=R;X=R+s;break}ac=[[aa,Z],[X,Z]];if(this.shadow){this.renderer.shadowRenderer.draw(af,ac,{lineCap:"butt",lineWidth:this.gridLineWidth*1.5,offset:this.gridLineWidth*0.75,fill:false,closePath:false})}W(aa,Z,X,Z,{strokeStyle:S.borderColor})}ae=null}V=null}S=null;ab=null}af.restore()}function W(ak,aj,ah,ag,ai){af.save();ai=ai||{};if(ai.lineWidth==null||ai.lineWidth!=0){y.extend(true,af,ai);af.beginPath();af.moveTo(ak,aj);af.lineTo(ah,ag);af.stroke();af.restore()}}if(this.shadow){var ac=[[this._left,this._bottom],[this._right,this._bottom],[this._right,this._top]];this.renderer.shadowRenderer.draw(af,ac)}if(this.borderWidth!=0&&this.drawBorder){W(this._left,this._top,this._right,this._top,{lineCap:"round",strokeStyle:Y.x2axis.borderColor,lineWidth:Y.x2axis.borderWidth});W(this._right,this._top,this._right,this._bottom,{lineCap:"round",strokeStyle:Y.y2axis.borderColor,lineWidth:Y.y2axis.borderWidth});W(this._right,this._bottom,this._left,this._bottom,{lineCap:"round",strokeStyle:Y.xaxis.borderColor,lineWidth:Y.xaxis.borderWidth});W(this._left,this._bottom,this._left,this._top,{lineCap:"round",strokeStyle:Y.yaxis.borderColor,lineWidth:Y.yaxis.borderWidth})}af.restore();af=null;Y=null};y.jqplot.DivTitleRenderer=function(){};y.jqplot.DivTitleRenderer.prototype.init=function(P){y.extend(true,this,P)};y.jqplot.DivTitleRenderer.prototype.draw=function(){var R=this.renderer;if(!this.text){this.show=false;this._elem=y('<div class="jqplot-title" style="height:0px;width:0px;"></div>')}else{if(this.text){var Q;if(this.color){Q=this.color}else{if(this.textColor){Q=this.textColor}}var P="position:absolute;top:0px;left:0px;";P+=(this._plotWidth)?"width:"+this._plotWidth+"px;":"";P+=(this.fontSize)?"font-size:"+this.fontSize+";":"";P+=(this.textAlign)?"text-align:"+this.textAlign+";":"text-align:center;";P+=(Q)?"color:"+Q+";":"";P+=(this.paddingBottom)?"padding-bottom:"+this.paddingBottom+";":"";this._elem=y('<div class="jqplot-title" style="'+P+'">'+this.text+"</div>");if(this.fontFamily){this._elem.css("font-family",this.fontFamily)}}}return this._elem};y.jqplot.DivTitleRenderer.prototype.pack=function(){};y.jqplot.LineRenderer=function(){this.shapeRenderer=new y.jqplot.ShapeRenderer();this.shadowRenderer=new y.jqplot.ShadowRenderer()};y.jqplot.LineRenderer.prototype.init=function(Q,U){Q=Q||{};var S={highlightMouseOver:Q.highlightMouseOver,highlightMouseDown:Q.highlightMouseDown,highlightColor:Q.highlightColor};delete (Q.highlightMouseOver);delete (Q.highlightMouseDown);delete (Q.highlightColor);y.extend(true,this.renderer,Q);var T={lineJoin:"round",lineCap:"round",fill:this.fill,isarc:false,strokeStyle:this.color,fillStyle:this.fillColor,lineWidth:this.lineWidth,closePath:this.fill};this.renderer.shapeRenderer.init(T);if(this.lineWidth>2.5){var R=this.shadowOffset*(1+(Math.atan((this.lineWidth/2.5))/0.785398163-1)*0.6)}else{var R=this.shadowOffset*Math.atan((this.lineWidth/2.5))/0.785398163}var P={lineJoin:"round",lineCap:"round",fill:this.fill,isarc:false,angle:this.shadowAngle,offset:R,alpha:this.shadowAlpha,depth:this.shadowDepth,lineWidth:this.lineWidth,closePath:this.fill};this.renderer.shadowRenderer.init(P);this._areaPoints=[];this._boundingBox=[[],[]];if(!this.isTrendline&&this.fill){this.highlightMouseOver=true;this.highlightMouseDown=false;this.highlightColor=null;if(S.highlightMouseDown&&S.highlightMouseOver==null){S.highlightMouseOver=false}y.extend(true,this,{highlightMouseOver:S.highlightMouseOver,highlightMouseDown:S.highlightMouseDown,highlightColor:S.highlightColor});if(!this.highlightColor){this.highlightColor=y.jqplot.computeHighlightColors(this.fillColor)}if(this.highlighter){this.highlighter.show=false}}if(!this.isTrendline&&U){U.plugins.lineRenderer={};U.postInitHooks.addOnce(p);U.postDrawHooks.addOnce(N);U.eventListenerHooks.addOnce("jqplotMouseMove",d);U.eventListenerHooks.addOnce("jqplotMouseDown",a);U.eventListenerHooks.addOnce("jqplotMouseUp",M);U.eventListenerHooks.addOnce("jqplotClick",c);U.eventListenerHooks.addOnce("jqplotRightClick",j)}};y.jqplot.LineRenderer.prototype.setGridData=function(U){var Q=this._xaxis.series_u2p;var T=this._yaxis.series_u2p;var R=this._plotData;var S=this._prevPlotData;this.gridData=[];this._prevGridData=[];for(var P=0;P<this.data.length;P++){if(R[P][0]!=null&&R[P][1]!=null){this.gridData.push([Q.call(this._xaxis,R[P][0]),T.call(this._yaxis,R[P][1])])}else{if(R[P][0]==null){this.gridData.push([null,T.call(this._yaxis,R[P][1])])}else{if(R[P][1]==null){this.gridData.push([Q.call(this._xaxis,R[P][0]),null])}}}if(S[P]!=null&&S[P][0]!=null&&S[P][1]!=null){this._prevGridData.push([Q.call(this._xaxis,S[P][0]),T.call(this._yaxis,S[P][1])])}else{if(S[P]!=null&&S[P][0]==null){this._prevGridData.push([null,T.call(this._yaxis,S[P][1])])}else{if(S[P]!=null&&S[P][0]!=null&&S[P][1]==null){this._prevGridData.push([Q.call(this._xaxis,S[P][0]),null])}}}}};y.jqplot.LineRenderer.prototype.makeGridData=function(S,U){var R=this._xaxis.series_u2p;var T=this._yaxis.series_u2p;var Q=[];var V=[];for(var P=0;P<S.length;P++){if(S[P][0]!=null&&S[P][1]!=null){Q.push([R.call(this._xaxis,S[P][0]),T.call(this._yaxis,S[P][1])])}else{if(S[P][0]==null){Q.push([null,T.call(this._yaxis,S[P][1])])}else{if(S[P][1]==null){Q.push([R.call(this._xaxis,S[P][0]),null])}}}}return Q};y.jqplot.LineRenderer.prototype.draw=function(ae,an,Q){var ai;var Y=(Q!=l)?Q:{};var S=(Y.shadow!=l)?Y.shadow:this.shadow;var ao=(Y.showLine!=l)?Y.showLine:this.showLine;var ah=(Y.fill!=l)?Y.fill:this.fill;var P=(Y.fillAndStroke!=l)?Y.fillAndStroke:this.fillAndStroke;var Z,af,ac,aj;ae.save();if(an.length){if(ao){if(ah){if(this.fillToZero){var T=new y.jqplot.ColorGenerator(this.negativeSeriesColors);var ak=T.get(this.index);if(!this.useNegativeColors){ak=Y.fillStyle}var W=false;var X=Y.fillStyle;if(P){var am=an.slice(0)}if(this.index==0||!this._stack){var ad=[];this._areaPoints=[];var al=this._yaxis.series_u2p(this.fillToValue);var R=this._xaxis.series_u2p(this.fillToValue);if(this.fillAxis=="y"){ad.push([an[0][0],al]);this._areaPoints.push([an[0][0],al]);for(var ai=0;ai<an.length-1;ai++){ad.push(an[ai]);this._areaPoints.push(an[ai]);if(this._plotData[ai][1]*this._plotData[ai+1][1]<0){if(this._plotData[ai][1]<0){W=true;Y.fillStyle=ak}else{W=false;Y.fillStyle=X}var V=an[ai][0]+(an[ai+1][0]-an[ai][0])*(al-an[ai][1])/(an[ai+1][1]-an[ai][1]);ad.push([V,al]);this._areaPoints.push([V,al]);if(S){this.renderer.shadowRenderer.draw(ae,ad,Y)}this.renderer.shapeRenderer.draw(ae,ad,Y);ad=[[V,al]]}}if(this._plotData[an.length-1][1]<0){W=true;Y.fillStyle=ak}else{W=false;Y.fillStyle=X}ad.push(an[an.length-1]);this._areaPoints.push(an[an.length-1]);ad.push([an[an.length-1][0],al]);this._areaPoints.push([an[an.length-1][0],al])}if(S){this.renderer.shadowRenderer.draw(ae,ad,Y)}this.renderer.shapeRenderer.draw(ae,ad,Y)}else{var ab=this._prevGridData;for(var ai=ab.length;ai>0;ai--){an.push(ab[ai-1])}if(S){this.renderer.shadowRenderer.draw(ae,an,Y)}this._areaPoints=an;this.renderer.shapeRenderer.draw(ae,an,Y)}}else{if(P){var am=an.slice(0)}if(this.index==0||!this._stack){var U=ae.canvas.height;an.unshift([an[0][0],U]);len=an.length;an.push([an[len-1][0],U])}else{var ab=this._prevGridData;for(var ai=ab.length;ai>0;ai--){an.push(ab[ai-1])}}this._areaPoints=an;if(S){this.renderer.shadowRenderer.draw(ae,an,Y)}this.renderer.shapeRenderer.draw(ae,an,Y)}if(P){var ag=y.extend(true,{},Y,{fill:false,closePath:false});this.renderer.shapeRenderer.draw(ae,am,ag);if(this.markerRenderer.show){for(ai=0;ai<am.length;ai++){this.markerRenderer.draw(am[ai][0],am[ai][1],ae,Y.markerOptions)}}}}else{if(S){this.renderer.shadowRenderer.draw(ae,an,Y)}this.renderer.shapeRenderer.draw(ae,an,Y)}}var Z=ac=af=aj=null;for(ai=0;ai<this._areaPoints.length;ai++){var aa=this._areaPoints[ai];if(Z>aa[0]||Z==null){Z=aa[0]}if(aj<aa[1]||aj==null){aj=aa[1]}if(ac<aa[0]||ac==null){ac=aa[0]}if(af>aa[1]||af==null){af=aa[1]}}this._boundingBox=[[Z,aj],[ac,af]];if(this.markerRenderer.show&&!ah){for(ai=0;ai<an.length;ai++){if(an[ai][0]!=null&&an[ai][1]!=null){this.markerRenderer.draw(an[ai][0],an[ai][1],ae,Y.markerOptions)}}}}ae.restore()};y.jqplot.LineRenderer.prototype.drawShadow=function(P,R,Q){};function p(R,Q,P){for(i=0;i<this.series.length;i++){if(this.series[i].renderer.constructor==y.jqplot.LineRenderer){if(this.series[i].highlightMouseOver){this.series[i].highlightMouseDown=false}}}this.target.bind("mouseout",{plot:this},function(S){J(S.data.plot)})}function N(){this.plugins.lineRenderer.highlightedSeriesIndex=null;this.plugins.lineRenderer.highlightCanvas=new y.jqplot.GenericCanvas();this.eventCanvas._elem.before(this.plugins.lineRenderer.highlightCanvas.createElement(this._gridPadding,"jqplot-lineRenderer-highlight-canvas",this._plotDimensions));this.plugins.lineRenderer.highlightCanvas.setContext()}function L(V,U,S,R){var Q=V.series[U];var P=V.plugins.lineRenderer.highlightCanvas;P._ctx.clearRect(0,0,P._ctx.canvas.width,P._ctx.canvas.height);Q._highlightedPoint=S;V.plugins.lineRenderer.highlightedSeriesIndex=U;var T={fillStyle:Q.highlightColor};Q.renderer.shapeRenderer.draw(P._ctx,R,T);P=null}function J(R){var P=R.plugins.lineRenderer.highlightCanvas;P._ctx.clearRect(0,0,P._ctx.canvas.width,P._ctx.canvas.height);for(var Q=0;Q<R.series.length;Q++){R.series[Q]._highlightedPoint=null}R.plugins.lineRenderer.highlightedSeriesIndex=null;R.target.trigger("jqplotDataUnhighlight");P=null}function d(T,S,W,V,U){if(V){var R=[V.seriesIndex,V.pointIndex,V.data];var Q=jQuery.Event("jqplotDataMouseOver");Q.pageX=T.pageX;Q.pageY=T.pageY;U.target.trigger(Q,R);if(U.series[R[0]].highlightMouseOver&&!(R[0]==U.plugins.lineRenderer.highlightedSeriesIndex)){var P=jQuery.Event("jqplotDataHighlight");P.pageX=T.pageX;P.pageY=T.pageY;U.target.trigger(P,R);L(U,V.seriesIndex,V.pointIndex,V.points)}}else{if(V==null){J(U)}}}function a(S,R,V,U,T){if(U){var Q=[U.seriesIndex,U.pointIndex,U.data];if(T.series[Q[0]].highlightMouseDown&&!(Q[0]==T.plugins.lineRenderer.highlightedSeriesIndex)){var P=jQuery.Event("jqplotDataHighlight");P.pageX=S.pageX;P.pageY=S.pageY;T.target.trigger(P,Q);L(T,U.seriesIndex,U.pointIndex,U.points)}}else{if(U==null){J(T)}}}function M(R,Q,U,T,S){var P=S.plugins.lineRenderer.highlightedSeriesIndex;if(P!=null&&S.series[P].highlightMouseDown){J(S)}}function c(S,R,V,U,T){if(U){var Q=[U.seriesIndex,U.pointIndex,U.data];var P=jQuery.Event("jqplotDataClick");P.pageX=S.pageX;P.pageY=S.pageY;T.target.trigger(P,Q)}}function j(T,S,W,V,U){if(V){var R=[V.seriesIndex,V.pointIndex,V.data];var P=U.plugins.lineRenderer.highlightedSeriesIndex;if(P!=null&&U.series[P].highlightMouseDown){J(U)}var Q=jQuery.Event("jqplotDataRightClick");Q.pageX=T.pageX;Q.pageY=T.pageY;U.target.trigger(Q,R)}}y.jqplot.LinearAxisRenderer=function(){};y.jqplot.LinearAxisRenderer.prototype.init=function(P){this.breakPoints=null;this.breakTickLabel="&asymp;";y.extend(true,this,P);if(this.breakPoints){if(!y.isArray(this.breakPoints)){this.breakPoints=null}else{if(this.breakPoints.length<2||this.breakPoints[1]<=this.breakPoints[0]){this.breakPoints=null}}}this.resetDataBounds()};y.jqplot.LinearAxisRenderer.prototype.draw=function(P){if(this.show){this.renderer.createTicks.call(this);var V=0;var Q;if(this._elem){this._elem.empty()}this._elem=y('<div class="jqplot-axis jqplot-'+this.name+'" style="position:absolute;"></div>');if(this.name=="xaxis"||this.name=="x2axis"){this._elem.width(this._plotDimensions.width)}else{this._elem.height(this._plotDimensions.height)}this.labelOptions.axis=this.name;this._label=new this.labelRenderer(this.labelOptions);var U;if(this._label.show){U=this._label.draw(P);U.appendTo(this._elem)}var T=this._ticks;for(var S=0;S<T.length;S++){var R=T[S];if(R.show&&R.showLabel&&(!R.isMinorTick||this.showMinorTicks)){U=R.draw(P);U.appendTo(this._elem)}}U=null}return this._elem};y.jqplot.LinearAxisRenderer.prototype.reset=function(){this.min=this._min;this.max=this._max;this.tickInterval=this._tickInterval;this.numberTicks=this._numberTicks};y.jqplot.LinearAxisRenderer.prototype.set=function(){var W=0;var R;var Q=0;var V=0;var P=(this._label==null)?false:this._label.show;if(this.show){var U=this._ticks;for(var T=0;T<U.length;T++){var S=U[T];if(!S._breakTick&&S.show&&S.showLabel&&(!S.isMinorTick||this.showMinorTicks)){if(this.name=="xaxis"||this.name=="x2axis"){R=S._elem.outerHeight(true)}else{R=S._elem.outerWidth(true)}if(R>W){W=R}}}if(P){Q=this._label._elem.outerWidth(true);V=this._label._elem.outerHeight(true)}if(this.name=="xaxis"){W=W+V;this._elem.css({height:W+"px",left:"0px",bottom:"0px"})}else{if(this.name=="x2axis"){W=W+V;this._elem.css({height:W+"px",left:"0px",top:"0px"})}else{if(this.name=="yaxis"){W=W+Q;this._elem.css({width:W+"px",left:"0px",top:"0px"});if(P&&this._label.constructor==y.jqplot.AxisLabelRenderer){this._label._elem.css("width",Q+"px")}}else{W=W+Q;this._elem.css({width:W+"px",right:"0px",top:"0px"});if(P&&this._label.constructor==y.jqplot.AxisLabelRenderer){this._label._elem.css("width",Q+"px")}}}}}};y.jqplot.LinearAxisRenderer.prototype.createTicks=function(){var ar=this._ticks;var al=this.ticks;var ac=this.name;var ae=this._dataBounds;var P,T;var aF,aj;var V,U;var aD,aA;var ai=this.min;var aE=this.max;var av=this.numberTicks;var aI=this.tickInterval;if(al.length){for(aA=0;aA<al.length;aA++){var ao=al[aA];var at=new this.tickRenderer(this.tickOptions);if(ao.constructor==Array){at.value=ao[0];if(this.breakPoints){if(ao[0]==this.breakPoints[0]){at.label=this.breakTickLabel;at._breakTick=true;at.showGridline=false;at.showMark=false}else{if(ao[0]>this.breakPoints[0]&&ao[0]<=this.breakPoints[1]){at.show=false;at.showGridline=false;at.label=ao[1]}else{at.label=ao[1]}}}else{at.label=ao[1]}at.setTick(ao[0],this.name);this._ticks.push(at)}else{at.value=ao;if(this.breakPoints){if(ao==this.breakPoints[0]){at.label=this.breakTickLabel;at._breakTick=true;at.showGridline=false;at.showMark=false}else{if(ao>this.breakPoints[0]&&ao<=this.breakPoints[1]){at.show=false;at.showGridline=false}}}at.setTick(ao,this.name);this._ticks.push(at)}}this.numberTicks=al.length;this.min=this._ticks[0].value;this.max=this._ticks[this.numberTicks-1].value;this.tickInterval=(this.max-this.min)/(this.numberTicks-1)}else{if(ac=="xaxis"||ac=="x2axis"){P=this._plotDimensions.width}else{P=this._plotDimensions.height}if(!this.autoscale&&this.min!=null&&this.max!=null&&this.numberTicks!=null){this.tickInterval=null}aF=((this.min!=null)?this.min:ae.min);aj=((this.max!=null)?this.max:ae.max);if(aF==aj){var Q=0.05;if(aF>0){Q=Math.max(Math.log(aF)/Math.LN10,0.05)}aF-=Q;aj+=Q}var aa=aj-aF;var ap,ab;var Y;if(this.autoscale&&this.min==null&&this.max==null){var R,S,X;var af=false;var an=false;var ad={min:null,max:null,average:null,stddev:null};for(var aA=0;aA<this._series.length;aA++){var au=this._series[aA];var ag=(au.fillAxis=="x")?au._xaxis.name:au._yaxis.name;if(this.name==ag){var aq=au._plotValues[au.fillAxis];var ah=aq[0];var aB=aq[0];for(var az=1;az<aq.length;az++){if(aq[az]<ah){ah=aq[az]}else{if(aq[az]>aB){aB=aq[az]}}}var Z=(aB-ah)/aB;if(au.renderer.constructor==y.jqplot.BarRenderer){if(ah>=0&&(au.fillToZero||Z>0.1)){af=true}else{af=false;if(au.fill&&au.fillToZero&&ah<0&&aB>0){an=true}else{an=false}}}else{if(au.fill){if(ah>=0&&(au.fillToZero||Z>0.1)){af=true}else{if(ah<0&&aB>0&&au.fillToZero){af=false;an=true}else{af=false;an=false}}}else{if(ah<0){af=false}}}}}if(af){this.numberTicks=2+Math.ceil((P-(this.tickSpacing-1))/this.tickSpacing);this.min=0;ai=0;S=aj/(this.numberTicks-1);Y=Math.pow(10,Math.abs(Math.floor(Math.log(S)/Math.LN10)));if(S/Y==parseInt(S/Y,10)){S+=Y}this.tickInterval=Math.ceil(S/Y)*Y;this.max=this.tickInterval*(this.numberTicks-1)}else{if(an){this.numberTicks=2+Math.ceil((P-(this.tickSpacing-1))/this.tickSpacing);var ak=Math.ceil(Math.abs(aF)/aa*(this.numberTicks-1));var aH=this.numberTicks-1-ak;S=Math.max(Math.abs(aF/ak),Math.abs(aj/aH));Y=Math.pow(10,Math.abs(Math.floor(Math.log(S)/Math.LN10)));this.tickInterval=Math.ceil(S/Y)*Y;this.max=this.tickInterval*aH;this.min=-this.tickInterval*ak}else{if(this.numberTicks==null){if(this.tickInterval){this.numberTicks=3+Math.ceil(aa/this.tickInterval)}else{this.numberTicks=2+Math.ceil((P-(this.tickSpacing-1))/this.tickSpacing)}}if(this.tickInterval==null){S=aa/(this.numberTicks-1);if(S<1){Y=Math.pow(10,Math.abs(Math.floor(Math.log(S)/Math.LN10)))}else{Y=1}this.tickInterval=Math.ceil(S*Y*this.pad)/Y}else{Y=1/this.tickInterval}R=this.tickInterval*(this.numberTicks-1);X=(R-aa)/2;if(this.min==null){this.min=Math.floor(Y*(aF-X))/Y}if(this.max==null){this.max=this.min+R}}}}else{ap=(this.min!=null)?this.min:aF-aa*(this.padMin-1);ab=(this.max!=null)?this.max:aj+aa*(this.padMax-1);this.min=ap;this.max=ab;aa=this.max-this.min;if(this.numberTicks==null){if(this.tickInterval!=null){this.numberTicks=Math.ceil((this.max-this.min)/this.tickInterval)+1;this.max=this.min+this.tickInterval*(this.numberTicks-1)}else{if(P>100){this.numberTicks=parseInt(3+(P-100)/75,10)}else{this.numberTicks=2}}}if(this.tickInterval==null){this.tickInterval=aa/(this.numberTicks-1)}}if(this.renderer.constructor==y.jqplot.LinearAxisRenderer){aa=this.max-this.min;var aG=new this.tickRenderer(this.tickOptions);var am=aG.formatString||y.jqplot.config.defaultTickFormatString;var am=am.match(y.jqplot.sprintf.regex)[0];var aC=0;if(am){if(am.search(/[fFeEgGpP]/)>-1){var ay=am.match(/\%\.(\d{0,})?[eEfFgGpP]/);if(ay){aC=parseInt(ay[1],10)}else{aC=6}}else{if(am.search(/[di]/)>-1){aC=0}}var W=Math.pow(10,-aC);if(this.tickInterval<W){if(av==null&&aI==null){this.tickInterval=W;if(aE==null&&ai==null){this.min=Math.floor(this._dataBounds.min/W)*W;if(this.min==this._dataBounds.min){this.min=this._dataBounds.min-this.tickInterval}this.max=Math.ceil(this._dataBounds.max/W)*W;if(this.max==this._dataBounds.max){this.max=this._dataBounds.max+this.tickInterval}var aw=(this.max-this.min)/this.tickInterval;aw=aw.toFixed(11);aw=Math.ceil(aw);this.numberTicks=aw+1}else{if(aE==null){var aw=(this._dataBounds.max-this.min)/this.tickInterval;aw=aw.toFixed(11);this.numberTicks=Math.ceil(aw)+2;this.max=this.min+this.tickInterval*(this.numberTicks-1)}else{if(ai==null){var aw=(this.max-this._dataBounds.min)/this.tickInterval;aw=aw.toFixed(11);this.numberTicks=Math.ceil(aw)+2;this.min=this.max-this.tickInterval*(this.numberTicks-1)}else{this.numberTicks=Math.ceil((aE-ai)/this.tickInterval)+1;this.min=Math.floor(ai*Math.pow(10,aC))/Math.pow(10,aC);this.max=Math.ceil(aE*Math.pow(10,aC))/Math.pow(10,aC);this.numberTicks=Math.ceil((this.max-this.min)/this.tickInterval)+1}}}}}}}for(var aA=0;aA<this.numberTicks;aA++){aD=this.min+aA*this.tickInterval;var at=new this.tickRenderer(this.tickOptions);at.setTick(aD,this.name);this._ticks.push(at)}}};y.jqplot.LinearAxisRenderer.prototype.resetTickValues=function(R){if(y.isArray(R)&&R.length==this._ticks.length){var Q;for(var P=0;P<R.length;P++){Q=this._ticks[P];Q.value=R[P];Q.label=Q.formatter(Q.formatString,R[P]);if(Q.prefix&&!Q.formatString){Q.label=Q.prefix+Q.label}Q._elem.html(Q.label)}this.min=y.jqplot.arrayMin(R);this.max=y.jqplot.arrayMax(R);this.pack()}};y.jqplot.LinearAxisRenderer.prototype.pack=function(Y,T){Y=Y||{};T=T||this._offsets;var ab=this._ticks;var Z=this.max;var V=this.min;var S=T.max;var af=T.min;var W=(this._label==null)?false:this._label.show;for(var P in Y){this._elem.css(P,Y[P])}this._offsets=T;var R=S-af;var ae=Z-V;if(this.breakPoints){ae=ae-this.breakPoints[1]+this.breakPoints[0];this.p2u=function(ag){return(ag-af)*ae/R+V};this.u2p=function(ag){if(ag>this.breakPoints[0]&&ag<this.breakPoints[1]){ag=this.breakPoints[0]}if(ag<=this.breakPoints[0]){return(ag-V)*R/ae+af}else{return(ag-this.breakPoints[1]+this.breakPoints[0]-V)*R/ae+af}};if(this.name.charAt(0)=="x"){this.series_u2p=function(ag){if(ag>this.breakPoints[0]&&ag<this.breakPoints[1]){ag=this.breakPoints[0]}if(ag<=this.breakPoints[0]){return(ag-V)*R/ae}else{return(ag-this.breakPoints[1]+this.breakPoints[0]-V)*R/ae}};this.series_p2u=function(ag){return ag*ae/R+V}}else{this.series_u2p=function(ag){if(ag>this.breakPoints[0]&&ag<this.breakPoints[1]){ag=this.breakPoints[0]}if(ag>=this.breakPoints[1]){return(ag-Z)*R/ae}else{return(ag+this.breakPoints[1]-this.breakPoints[0]-Z)*R/ae}};this.series_p2u=function(ag){return ag*ae/R+Z}}}else{this.p2u=function(ag){return(ag-af)*ae/R+V};this.u2p=function(ag){return(ag-V)*R/ae+af};if(this.name=="xaxis"||this.name=="x2axis"){this.series_u2p=function(ag){return(ag-V)*R/ae};this.series_p2u=function(ag){return ag*ae/R+V}}else{this.series_u2p=function(ag){return(ag-Z)*R/ae};this.series_p2u=function(ag){return ag*ae/R+Z}}}if(this.show){if(this.name=="xaxis"||this.name=="x2axis"){for(i=0;i<ab.length;i++){var ad=ab[i];if(ad.show&&ad.showLabel){var U;if(ad.constructor==y.jqplot.CanvasAxisTickRenderer&&ad.angle){var ac=(this.name=="xaxis")?1:-1;switch(ad.labelPosition){case"auto":if(ac*ad.angle<0){U=-ad.getWidth()+ad._textRenderer.height*Math.sin(-ad._textRenderer.angle)/2}else{U=-ad._textRenderer.height*Math.sin(ad._textRenderer.angle)/2}break;case"end":U=-ad.getWidth()+ad._textRenderer.height*Math.sin(-ad._textRenderer.angle)/2;break;case"start":U=-ad._textRenderer.height*Math.sin(ad._textRenderer.angle)/2;break;case"middle":U=-ad.getWidth()/2+ad._textRenderer.height*Math.sin(-ad._textRenderer.angle)/2;break;default:U=-ad.getWidth()/2+ad._textRenderer.height*Math.sin(-ad._textRenderer.angle)/2;break}}else{U=-ad.getWidth()/2}var Q=this.u2p(ad.value)+U+"px";ad._elem.css("left",Q);ad.pack()}}if(W){var aa=this._label._elem.outerWidth(true);this._label._elem.css("left",af+R/2-aa/2+"px");if(this.name=="xaxis"){this._label._elem.css("bottom","0px")}else{this._label._elem.css("top","0px")}this._label.pack()}}else{for(i=0;i<ab.length;i++){var ad=ab[i];if(ad.show&&ad.showLabel){var U;if(ad.constructor==y.jqplot.CanvasAxisTickRenderer&&ad.angle){var ac=(this.name=="yaxis")?1:-1;switch(ad.labelPosition){case"auto":case"end":if(ac*ad.angle<0){U=-ad._textRenderer.height*Math.cos(-ad._textRenderer.angle)/2}else{U=-ad.getHeight()+ad._textRenderer.height*Math.cos(ad._textRenderer.angle)/2}break;case"start":if(ad.angle>0){U=-ad._textRenderer.height*Math.cos(-ad._textRenderer.angle)/2}else{U=-ad.getHeight()+ad._textRenderer.height*Math.cos(ad._textRenderer.angle)/2}break;case"middle":U=-ad.getHeight()/2;break;default:U=-ad.getHeight()/2;break}}else{U=-ad.getHeight()/2}var Q=this.u2p(ad.value)+U+"px";ad._elem.css("top",Q);ad.pack()}}if(W){var X=this._label._elem.outerHeight(true);this._label._elem.css("top",S-R/2-X/2+"px");if(this.name=="yaxis"){this._label._elem.css("left","0px")}else{this._label._elem.css("right","0px")}this._label.pack()}}}};y.jqplot.MarkerRenderer=function(P){this.show=true;this.style="filledCircle";this.lineWidth=2;this.size=9;this.color="#666666";this.shadow=true;this.shadowAngle=45;this.shadowOffset=1;this.shadowDepth=3;this.shadowAlpha="0.07";this.shadowRenderer=new y.jqplot.ShadowRenderer();this.shapeRenderer=new y.jqplot.ShapeRenderer();y.extend(true,this,P)};y.jqplot.MarkerRenderer.prototype.init=function(P){y.extend(true,this,P);var R={angle:this.shadowAngle,offset:this.shadowOffset,alpha:this.shadowAlpha,lineWidth:this.lineWidth,depth:this.shadowDepth,closePath:true};if(this.style.indexOf("filled")!=-1){R.fill=true}if(this.style.indexOf("ircle")!=-1){R.isarc=true;R.closePath=false}this.shadowRenderer.init(R);var Q={fill:false,isarc:false,strokeStyle:this.color,fillStyle:this.color,lineWidth:this.lineWidth,closePath:true};if(this.style.indexOf("filled")!=-1){Q.fill=true}if(this.style.indexOf("ircle")!=-1){Q.isarc=true;Q.closePath=false}this.shapeRenderer.init(Q)};y.jqplot.MarkerRenderer.prototype.drawDiamond=function(R,Q,U,T,W){var P=1.2;var X=this.size/2/P;var V=this.size/2*P;var S=[[R-X,Q],[R,Q+V],[R+X,Q],[R,Q-V]];if(this.shadow){this.shadowRenderer.draw(U,S)}this.shapeRenderer.draw(U,S,W)};y.jqplot.MarkerRenderer.prototype.drawPlus=function(S,R,V,U,Y){var Q=1;var Z=this.size/2*Q;var W=this.size/2*Q;var X=[[S,R-W],[S,R+W]];var T=[[S+Z,R],[S-Z,R]];var P=y.extend(true,{},this.options,{closePath:false});if(this.shadow){this.shadowRenderer.draw(V,X,{closePath:false});this.shadowRenderer.draw(V,T,{closePath:false})}this.shapeRenderer.draw(V,X,P);this.shapeRenderer.draw(V,T,P)};y.jqplot.MarkerRenderer.prototype.drawX=function(S,R,V,U,Y){var Q=1;var Z=this.size/2*Q;var W=this.size/2*Q;var P=y.extend(true,{},this.options,{closePath:false});var X=[[S-Z,R-W],[S+Z,R+W]];var T=[[S-Z,R+W],[S+Z,R-W]];if(this.shadow){this.shadowRenderer.draw(V,X,{closePath:false});this.shadowRenderer.draw(V,T,{closePath:false})}this.shapeRenderer.draw(V,X,P);this.shapeRenderer.draw(V,T,P)};y.jqplot.MarkerRenderer.prototype.drawDash=function(R,Q,U,T,W){var P=1;var X=this.size/2*P;var V=this.size/2*P;var S=[[R-X,Q],[R+X,Q]];if(this.shadow){this.shadowRenderer.draw(U,S)}this.shapeRenderer.draw(U,S,W)};y.jqplot.MarkerRenderer.prototype.drawLine=function(U,T,P,S,Q){var R=[U,T];if(this.shadow){this.shadowRenderer.draw(P,R)}this.shapeRenderer.draw(P,R,Q)};y.jqplot.MarkerRenderer.prototype.drawSquare=function(R,Q,U,T,W){var P=1;var X=this.size/2/P;var V=this.size/2*P;var S=[[R-X,Q-V],[R-X,Q+V],[R+X,Q+V],[R+X,Q-V]];if(this.shadow){this.shadowRenderer.draw(U,S)}this.shapeRenderer.draw(U,S,W)};y.jqplot.MarkerRenderer.prototype.drawCircle=function(Q,W,S,V,T){var P=this.size/2;var R=2*Math.PI;var U=[Q,W,P,0,R,true];if(this.shadow){this.shadowRenderer.draw(S,U)}this.shapeRenderer.draw(S,U,T)};y.jqplot.MarkerRenderer.prototype.draw=function(P,S,Q,R){R=R||{};if(R.show==null||R.show!=false){if(R.color&&!R.fillStyle){R.fillStyle=R.color}if(R.color&&!R.strokeStyle){R.strokeStyle=R.color}switch(this.style){case"diamond":this.drawDiamond(P,S,Q,false,R);break;case"filledDiamond":this.drawDiamond(P,S,Q,true,R);break;case"circle":this.drawCircle(P,S,Q,false,R);break;case"filledCircle":this.drawCircle(P,S,Q,true,R);break;case"square":this.drawSquare(P,S,Q,false,R);break;case"filledSquare":this.drawSquare(P,S,Q,true,R);break;case"x":this.drawX(P,S,Q,true,R);break;case"plus":this.drawPlus(P,S,Q,true,R);break;case"dash":this.drawDash(P,S,Q,true,R);break;case"line":this.drawLine(P,S,Q,false,R);break;default:this.drawDiamond(P,S,Q,false,R);break}}};y.jqplot.ShadowRenderer=function(P){this.angle=45;this.offset=1;this.alpha=0.07;this.lineWidth=1.5;this.lineJoin="miter";this.lineCap="round";this.closePath=false;this.fill=false;this.depth=3;this.strokeStyle="rgba(0,0,0,0.1)";this.isarc=false;y.extend(true,this,P)};y.jqplot.ShadowRenderer.prototype.init=function(P){y.extend(true,this,P)};y.jqplot.ShadowRenderer.prototype.draw=function(Z,X,ab){Z.save();var P=(ab!=null)?ab:{};var Y=(P.fill!=null)?P.fill:this.fill;var W=(P.closePath!=null)?P.closePath:this.closePath;var T=(P.offset!=null)?P.offset:this.offset;var R=(P.alpha!=null)?P.alpha:this.alpha;var V=(P.depth!=null)?P.depth:this.depth;var aa=(P.isarc!=null)?P.isarc:this.isarc;Z.lineWidth=(P.lineWidth!=null)?P.lineWidth:this.lineWidth;Z.lineJoin=(P.lineJoin!=null)?P.lineJoin:this.lineJoin;Z.lineCap=(P.lineCap!=null)?P.lineCap:this.lineCap;Z.strokeStyle=P.strokeStyle||this.strokeStyle||"rgba(0,0,0,"+R+")";Z.fillStyle=P.fillStyle||this.fillStyle||"rgba(0,0,0,"+R+")";for(var S=0;S<V;S++){Z.translate(Math.cos(this.angle*Math.PI/180)*T,Math.sin(this.angle*Math.PI/180)*T);Z.beginPath();if(aa){Z.arc(X[0],X[1],X[2],X[3],X[4],true)}else{if(X&&X.length){var Q=true;for(var U=0;U<X.length;U++){if(X[U][0]!=null&&X[U][1]!=null){if(Q){Z.moveTo(X[U][0],X[U][1]);Q=false}else{Z.lineTo(X[U][0],X[U][1])}}else{Q=true}}}}if(W){Z.closePath()}if(Y){Z.fill()}else{Z.stroke()}}Z.restore()};y.jqplot.ShapeRenderer=function(P){this.lineWidth=1.5;this.lineJoin="miter";this.lineCap="round";this.closePath=false;this.fill=false;this.isarc=false;this.fillRect=false;this.strokeRect=false;this.clearRect=false;this.strokeStyle="#999999";this.fillStyle="#999999";y.extend(true,this,P)};y.jqplot.ShapeRenderer.prototype.init=function(P){y.extend(true,this,P)};y.jqplot.ShapeRenderer.prototype.draw=function(Y,W,aa){Y.save();var P=(aa!=null)?aa:{};var X=(P.fill!=null)?P.fill:this.fill;var U=(P.closePath!=null)?P.closePath:this.closePath;var V=(P.fillRect!=null)?P.fillRect:this.fillRect;var S=(P.strokeRect!=null)?P.strokeRect:this.strokeRect;var Q=(P.clearRect!=null)?P.clearRect:this.clearRect;var Z=(P.isarc!=null)?P.isarc:this.isarc;Y.lineWidth=P.lineWidth||this.lineWidth;Y.lineJoin=P.lineJoing||this.lineJoin;Y.lineCap=P.lineCap||this.lineCap;Y.strokeStyle=(P.strokeStyle||P.color)||this.strokeStyle;Y.fillStyle=P.fillStyle||this.fillStyle;Y.beginPath();if(Z){Y.arc(W[0],W[1],W[2],W[3],W[4],true);if(U){Y.closePath()}if(X){Y.fill()}else{Y.stroke()}Y.restore();return}else{if(Q){Y.clearRect(W[0],W[1],W[2],W[3]);Y.restore();return}else{if(V||S){if(V){Y.fillRect(W[0],W[1],W[2],W[3])}if(S){Y.strokeRect(W[0],W[1],W[2],W[3]);Y.restore();return}}else{if(W&&W.length){var R=true;for(var T=0;T<W.length;T++){if(W[T][0]!=null&&W[T][1]!=null){if(R){Y.moveTo(W[T][0],W[T][1]);R=false}else{Y.lineTo(W[T][0],W[T][1])}}else{R=true}}if(U){Y.closePath()}if(X){Y.fill()}else{Y.stroke()}}}}}Y.restore()};y.jqplot.TableLegendRenderer=function(){};y.jqplot.TableLegendRenderer.prototype.init=function(P){y.extend(true,this,P)};y.jqplot.TableLegendRenderer.prototype.addrow=function(S,Q,V,R){var P=(V)?this.rowSpacing:"0";var U,T;if(R){U=y('<tr class="jqplot-table-legend"></tr>').prependTo(this._elem)}else{U=y('<tr class="jqplot-table-legend"></tr>').appendTo(this._elem)}if(this.showSwatches){y('<td class="jqplot-table-legend" style="text-align:center;padding-top:'+P+';"><div><div class="jqplot-table-legend-swatch" style="background-color:'+Q+";border-color:"+Q+';"></div></div></td>').appendTo(U)}if(this.showLabels){T=y('<td class="jqplot-table-legend" style="padding-top:'+P+';"></td>');T.appendTo(U);if(this.escapeHtml){T.text(S)}else{T.html(S)}}U=null;T=null};y.jqplot.TableLegendRenderer.prototype.draw=function(){var W=this;if(this.show){var T=this._series;var Y="position:absolute;";Y+=(this.background)?"background:"+this.background+";":"";Y+=(this.border)?"border:"+this.border+";":"";Y+=(this.fontSize)?"font-size:"+this.fontSize+";":"";Y+=(this.fontFamily)?"font-family:"+this.fontFamily+";":"";Y+=(this.textColor)?"color:"+this.textColor+";":"";Y+=(this.marginTop!=null)?"margin-top:"+this.marginTop+";":"";Y+=(this.marginBottom!=null)?"margin-bottom:"+this.marginBottom+";":"";Y+=(this.marginLeft!=null)?"margin-left:"+this.marginLeft+";":"";Y+=(this.marginRight!=null)?"margin-right:"+this.marginRight+";":"";this._elem=y('<table class="jqplot-table-legend" style="'+Y+'"></table>');var P=false,V=false;for(var U=0;U<T.length;U++){s=T[U];if(s._stack||s.renderer.constructor==y.jqplot.BezierCurveRenderer){V=true}if(s.show&&s.showLabel){var S=this.labels[U]||s.label.toString();if(S){var Q=s.color;if(V&&U<T.length-1){P=true}else{if(V&&U==T.length-1){P=false}}this.renderer.addrow.call(this,S,Q,P,V);P=true}for(var R=0;R<y.jqplot.addLegendRowHooks.length;R++){var X=y.jqplot.addLegendRowHooks[R].call(this,s);if(X){this.renderer.addrow.call(this,X.label,X.color,P);P=true}}S=null}}}return this._elem};y.jqplot.TableLegendRenderer.prototype.pack=function(R){if(this.show){if(this.placement=="insideGrid"){switch(this.location){case"nw":var Q=R.left;var P=R.top;this._elem.css("left",Q);this._elem.css("top",P);break;case"n":var Q=(R.left+(this._plotDimensions.width-R.right))/2-this.getWidth()/2;var P=R.top;this._elem.css("left",Q);this._elem.css("top",P);break;case"ne":var Q=R.right;var P=R.top;this._elem.css({right:Q,top:P});break;case"e":var Q=R.right;var P=(R.top+(this._plotDimensions.height-R.bottom))/2-this.getHeight()/2;this._elem.css({right:Q,top:P});break;case"se":var Q=R.right;var P=R.bottom;this._elem.css({right:Q,bottom:P});break;case"s":var Q=(R.left+(this._plotDimensions.width-R.right))/2-this.getWidth()/2;var P=R.bottom;this._elem.css({left:Q,bottom:P});break;case"sw":var Q=R.left;var P=R.bottom;this._elem.css({left:Q,bottom:P});break;case"w":var Q=R.left;var P=(R.top+(this._plotDimensions.height-R.bottom))/2-this.getHeight()/2;this._elem.css({left:Q,top:P});break;default:var Q=R.right;var P=R.bottom;this._elem.css({right:Q,bottom:P});break}}else{if(this.placement=="outside"){switch(this.location){case"nw":var Q=this._plotDimensions.width-R.left;var P=R.top;this._elem.css("right",Q);this._elem.css("top",P);break;case"n":var Q=(R.left+(this._plotDimensions.width-R.right))/2-this.getWidth()/2;var P=this._plotDimensions.height-R.top;this._elem.css("left",Q);this._elem.css("bottom",P);break;case"ne":var Q=this._plotDimensions.width-R.right;var P=R.top;this._elem.css({left:Q,top:P});break;case"e":var Q=this._plotDimensions.width-R.right;var P=(R.top+(this._plotDimensions.height-R.bottom))/2-this.getHeight()/2;this._elem.css({left:Q,top:P});break;case"se":var Q=this._plotDimensions.width-R.right;var P=R.bottom;this._elem.css({left:Q,bottom:P});break;case"s":var Q=(R.left+(this._plotDimensions.width-R.right))/2-this.getWidth()/2;var P=this._plotDimensions.height-R.bottom;this._elem.css({left:Q,top:P});break;case"sw":var Q=this._plotDimensions.width-R.left;var P=R.bottom;this._elem.css({right:Q,bottom:P});break;case"w":var Q=this._plotDimensions.width-R.left;var P=(R.top+(this._plotDimensions.height-R.bottom))/2-this.getHeight()/2;this._elem.css({right:Q,top:P});break;default:var Q=R.right;var P=R.bottom;this._elem.css({right:Q,bottom:P});break}}else{switch(this.location){case"nw":this._elem.css({left:0,top:R.top});break;case"n":var Q=(R.left+(this._plotDimensions.width-R.right))/2-this.getWidth()/2;this._elem.css({left:Q,top:R.top});break;case"ne":this._elem.css({right:0,top:R.top});break;case"e":var P=(R.top+(this._plotDimensions.height-R.bottom))/2-this.getHeight()/2;this._elem.css({right:R.right,top:P});break;case"se":this._elem.css({right:R.right,bottom:R.bottom});break;case"s":var Q=(R.left+(this._plotDimensions.width-R.right))/2-this.getWidth()/2;this._elem.css({left:Q,bottom:R.bottom});break;case"sw":this._elem.css({left:R.left,bottom:R.bottom});break;case"w":var P=(R.top+(this._plotDimensions.height-R.bottom))/2-this.getHeight()/2;this._elem.css({left:R.left,top:P});break;default:this._elem.css({right:R.right,bottom:R.bottom});break}}}}};y.jqplot.ThemeEngine=function(){this.themes={};this.activeTheme=null};y.jqplot.ThemeEngine.prototype.init=function(){var S=new y.jqplot.Theme({_name:"Default"});var U,Q;for(U in S.target){if(U=="textColor"){S.target[U]=this.target.css("color")}else{S.target[U]=this.target.css(U)}}if(this.title.show&&this.title._elem){for(U in S.title){if(U=="textColor"){S.title[U]=this.title._elem.css("color")}else{S.title[U]=this.title._elem.css(U)}}}for(U in S.grid){S.grid[U]=this.grid[U]}if(S.grid.backgroundColor==null&&this.grid.background!=null){S.grid.backgroundColor=this.grid.background}if(this.legend.show&&this.legend._elem){for(U in S.legend){if(U=="textColor"){S.legend[U]=this.legend._elem.css("color")}else{S.legend[U]=this.legend._elem.css(U)}}}var R;for(Q=0;Q<this.series.length;Q++){R=this.series[Q];if(R.renderer.constructor==y.jqplot.LineRenderer){S.series.push(new h())}else{if(R.renderer.constructor==y.jqplot.BarRenderer){S.series.push(new F())}else{if(R.renderer.constructor==y.jqplot.PieRenderer){S.series.push(new b())}else{if(R.renderer.constructor==y.jqplot.DonutRenderer){S.series.push(new v())}else{if(R.renderer.constructor==y.jqplot.FunnelRenderer){S.series.push(new I())}else{if(R.renderer.constructor==y.jqplot.MeterGaugeRenderer){S.series.push(new t())}else{S.series.push({})}}}}}}for(U in S.series[Q]){S.series[Q][U]=R[U]}}var P,T;for(U in this.axes){T=this.axes[U];P=S.axes[U]=new C();P.borderColor=T.borderColor;P.borderWidth=T.borderWidth;if(T._ticks&&T._ticks[0]){for(nn in P.ticks){if(T._ticks[0].hasOwnProperty(nn)){P.ticks[nn]=T._ticks[0][nn]}else{if(T._ticks[0]._elem){P.ticks[nn]=T._ticks[0]._elem.css(nn)}}}}if(T._label&&T._label.show){for(nn in P.label){if(T._label[nn]){P.label[nn]=T._label[nn]}else{if(T._label._elem){if(nn=="textColor"){P.label[nn]=T._label._elem.css("color")}else{P.label[nn]=T._label._elem.css(nn)}}}}}}this.themeEngine._add(S);this.themeEngine.activeTheme=this.themeEngine.themes[S._name]};y.jqplot.ThemeEngine.prototype.get=function(P){if(!P){return this.activeTheme}else{return this.themes[P]}};function B(Q,P){return Q-P}y.jqplot.ThemeEngine.prototype.getThemeNames=function(){var P=[];for(var Q in this.themes){P.push(Q)}return P.sort(B)};y.jqplot.ThemeEngine.prototype.getThemes=function(){var Q=[];var P=[];for(var S in this.themes){Q.push(S)}Q.sort(B);for(var R=0;R<Q.length;R++){P.push(this.themes[Q[R]])}return P};y.jqplot.ThemeEngine.prototype.activate=function(aa,S){var af=false;if(!S&&this.activeTheme&&this.activeTheme._name){S=this.activeTheme._name}if(!this.themes.hasOwnProperty(S)){throw new Error("No theme of that name")}else{var T=this.themes[S];this.activeTheme=T;var V,ae=false,ab=false;var Z=["xaxis","x2axis","yaxis","y2axis"];for(Y=0;Y<Z.length;Y++){var R=Z[Y];if(T.axesStyles.borderColor!=null){aa.axes[R].borderColor=T.axesStyles.borderColor}if(T.axesStyles.borderWidth!=null){aa.axes[R].borderWidth=T.axesStyles.borderWidth}}for(axname in aa.axes){var W=aa.axes[axname];if(W.show){var ad=T.axes[axname]||{};var Q=T.axesStyles;var X=y.jqplot.extend(true,{},ad,Q);V=(T.axesStyles.borderColor!=null)?T.axesStyles.borderColor:X.borderColor;if(X.borderColor!=null){W.borderColor=X.borderColor;af=true}V=(T.axesStyles.borderWidth!=null)?T.axesStyles.borderWidth:X.borderWidth;if(X.borderWidth!=null){W.borderWidth=X.borderWidth;af=true}if(W._ticks&&W._ticks[0]){for(nn in X.ticks){V=X.ticks[nn];if(V!=null){W.tickOptions[nn]=V;W._ticks=[];af=true}}}if(W._label&&W._label.show){for(nn in X.label){V=X.label[nn];if(V!=null){W.labelOptions[nn]=V;af=true}}}}}for(var U in T.grid){if(T.grid[U]!=null){aa.grid[U]=T.grid[U]}}if(!af){aa.grid.draw()}if(aa.legend.show){for(U in T.legend){if(T.legend[U]!=null){aa.legend[U]=T.legend[U]}}}if(aa.title.show){for(U in T.title){if(T.title[U]!=null){aa.title[U]=T.title[U]}}}var Y;for(Y=0;Y<T.series.length;Y++){var P={};var ac=false;for(U in T.series[Y]){V=(T.seriesStyles[U]!=null)?T.seriesStyles[U]:T.series[Y][U];if(V!=null){P[U]=V;if(U=="color"){aa.series[Y].renderer.shapeRenderer.fillStyle=V;aa.series[Y].renderer.shapeRenderer.strokeStyle=V;aa.series[Y][U]=V}else{if(U=="lineWidth"){aa.series[Y].renderer.shapeRenderer.lineWidth=V;aa.series[Y][U]=V}else{if(U=="markerOptions"){G(aa.series[Y].markerOptions,V);G(aa.series[Y].markerRenderer,V)}else{aa.series[Y][U]=V}}}af=true}}}if(af){aa.target.empty();aa.draw()}for(U in T.target){if(T.target[U]!=null){aa.target.css(U,T.target[U])}}}};y.jqplot.ThemeEngine.prototype._add=function(Q,P){if(P){Q._name=P}if(!Q._name){Q._name=Date.parse(new Date())}if(!this.themes.hasOwnProperty(Q._name)){this.themes[Q._name]=Q}else{throw new Error("jqplot.ThemeEngine Error: Theme already in use")}};y.jqplot.ThemeEngine.prototype.remove=function(P){if(P=="Default"){return false}return delete this.themes[P]};y.jqplot.ThemeEngine.prototype.newTheme=function(P,R){if(typeof(P)=="object"){R=R||P;P=null}if(R&&R._name){P=R._name}else{P=P||Date.parse(new Date())}var Q=this.copy(this.themes.Default._name,P);y.jqplot.extend(Q,R);return Q};function q(R){if(R==null||typeof(R)!="object"){return R}var P=new R.constructor();for(var Q in R){P[Q]=q(R[Q])}return P}y.jqplot.clone=q;function G(R,Q){if(Q==null||typeof(Q)!="object"){return}for(var P in Q){if(P=="highlightColors"){R[P]=q(Q[P])}if(Q[P]!=null&&typeof(Q[P])=="object"){if(!R.hasOwnProperty(P)){R[P]={}}G(R[P],Q[P])}else{R[P]=Q[P]}}}y.jqplot.merge=G;y.jqplot.extend=function(){var U=arguments[0]||{},S=1,T=arguments.length,P=false,R;if(typeof U==="boolean"){P=U;U=arguments[1]||{};S=2}if(typeof U!=="object"&&!toString.call(U)==="[object Function]"){U={}}for(;S<T;S++){if((R=arguments[S])!=null){for(var Q in R){var V=U[Q],W=R[Q];if(U===W){continue}if(P&&W&&typeof W==="object"&&!W.nodeType){U[Q]=y.jqplot.extend(P,V||(W.length!=null?[]:{}),W)}else{if(W!==l){U[Q]=W}}}}}return U};y.jqplot.ThemeEngine.prototype.rename=function(Q,P){if(Q=="Default"||P=="Default"){throw new Error("jqplot.ThemeEngine Error: Cannot rename from/to Default")}if(this.themes.hasOwnProperty(P)){throw new Error("jqplot.ThemeEngine Error: New name already in use.")}else{if(this.themes.hasOwnProperty(Q)){var R=this.copy(Q,P);this.remove(Q);return R}}throw new Error("jqplot.ThemeEngine Error: Old name or new name invalid")};y.jqplot.ThemeEngine.prototype.copy=function(P,R,T){if(R=="Default"){throw new Error("jqplot.ThemeEngine Error: Cannot copy over Default theme")}if(!this.themes.hasOwnProperty(P)){var Q="jqplot.ThemeEngine Error: Source name invalid";throw new Error(Q)}if(this.themes.hasOwnProperty(R)){var Q="jqplot.ThemeEngine Error: Target name invalid";throw new Error(Q)}else{var S=q(this.themes[P]);S._name=R;y.jqplot.extend(true,S,T);this._add(S);return S}};y.jqplot.Theme=function(P,Q){if(typeof(P)=="object"){Q=Q||P;P=null}P=P||Date.parse(new Date());this._name=P;this.target={backgroundColor:null};this.legend={textColor:null,fontFamily:null,fontSize:null,border:null,background:null};this.title={textColor:null,fontFamily:null,fontSize:null,textAlign:null};this.seriesStyles={};this.series=[];this.grid={drawGridlines:null,gridLineColor:null,gridLineWidth:null,backgroundColor:null,borderColor:null,borderWidth:null,shadow:null};this.axesStyles={label:{},ticks:{}};this.axes={};if(typeof(Q)=="string"){this._name=Q}else{if(typeof(Q)=="object"){y.jqplot.extend(true,this,Q)}}};var C=function(){this.borderColor=null;this.borderWidth=null;this.ticks=new f();this.label=new k()};var f=function(){this.show=null;this.showGridline=null;this.showLabel=null;this.showMark=null;this.size=null;this.textColor=null;this.whiteSpace=null;this.fontSize=null;this.fontFamily=null};var k=function(){this.textColor=null;this.whiteSpace=null;this.fontSize=null;this.fontFamily=null;this.fontWeight=null};var h=function(){this.color=null;this.lineWidth=null;this.shadow=null;this.fillColor=null;this.showMarker=null;this.markerOptions=new x()};var x=function(){this.show=null;this.style=null;this.lineWidth=null;this.size=null;this.color=null;this.shadow=null};var F=function(){this.color=null;this.seriesColors=null;this.lineWidth=null;this.shadow=null;this.barPadding=null;this.barMargin=null;this.barWidth=null;this.highlightColors=null};var b=function(){this.seriesColors=null;this.padding=null;this.sliceMargin=null;this.fill=null;this.shadow=null;this.startAngle=null;this.lineWidth=null;this.highlightColors=null};var v=function(){this.seriesColors=null;this.padding=null;this.sliceMargin=null;this.fill=null;this.shadow=null;this.startAngle=null;this.lineWidth=null;this.innerDiameter=null;this.thickness=null;this.ringMargin=null;this.highlightColors=null};var I=function(){this.color=null;this.lineWidth=null;this.shadow=null;this.padding=null;this.sectionMargin=null;this.seriesColors=null;this.highlightColors=null};var t=function(){this.padding=null;this.backgroundColor=null;this.ringColor=null;this.tickColor=null;this.ringWidth=null;this.intervalColors=null;this.intervalInnerRadius=null;this.intervalOuterRadius=null;this.hubRadius=null;this.needleThickness=null;this.needlePad=null};var O=function(){this.syntax=O.config.syntax;this._type="jsDate";this.utcOffset=new Date().getTimezoneOffset*60000;this.proxy=new Date();this.options={};this.locale=O.regional.getLocale();this.formatString="";this.defaultCentury=O.config.defaultCentury;switch(arguments.length){case 0:break;case 1:if(e(arguments[0])=="[object Object]"&&arguments[0]._type!="jsDate"){var R=this.options=arguments[0];this.syntax=R.syntax||this.syntax;this.defaultCentury=R.defaultCentury||this.defaultCentury;this.proxy=O.createDate(R.date)}else{this.proxy=O.createDate(arguments[0])}break;default:var P=[];for(var Q=0;Q<arguments.length;Q++){P.push(arguments[Q])}this.proxy=new Date(this.utcOffset);this.proxy.setFullYear.apply(this.proxy,P.slice(0,3));if(P.slice(3).length){this.proxy.setHours.apply(this.proxy,P.slice(3))}break}};O.config={defaultLocale:"en",syntax:"perl",defaultCentury:1900};O.prototype.add=function(R,Q){var P=u[Q]||u.day;if(typeof P=="number"){this.proxy.setTime(this.proxy.getTime()+(P*R))}else{P.add(this,R)}return this};O.prototype.clone=function(){return new O(this.proxy.getTime())};O.prototype.diff=function(Q,T,P){Q=new O(Q);if(Q===null){return null}var R=u[T]||u.day;if(typeof R=="number"){var S=(this.proxy.getTime()-Q.proxy.getTime())/R}else{var S=R.diff(this.proxy,Q.proxy)}return(P?S:Math[S>0?"floor":"ceil"](S))};O.prototype.getAbbrDayName=function(){return O.regional[this.locale]["dayNamesShort"][this.proxy.getDay()]};O.prototype.getAbbrMonthName=function(){return O.regional[this.locale]["monthNamesShort"][this.proxy.getMonth()]};O.prototype.getAMPM=function(){return this.proxy.getHours()>=12?"PM":"AM"};O.prototype.getAmPm=function(){return this.proxy.getHours()>=12?"pm":"am"};O.prototype.getCentury=function(){return parseInt(this.proxy.getFullYear()/100,10)};O.prototype.getDate=function(){return this.proxy.getDate()};O.prototype.getDay=function(){return this.proxy.getDay()};O.prototype.getDayOfWeek=function(){var P=this.proxy.getDay();return P===0?7:P};O.prototype.getDayOfYear=function(){var Q=this.proxy;var P=Q-new Date(""+Q.getFullYear()+"/1/1 GMT");P+=Q.getTimezoneOffset()*60000;Q=null;return parseInt(P/60000/60/24,10)+1};O.prototype.getDayName=function(){return O.regional[this.locale]["dayNames"][this.proxy.getDay()]};O.prototype.getFullWeekOfYear=function(){var S=this.proxy;var P=this.getDayOfYear();var R=6-S.getDay();var Q=parseInt((P+R)/7,10);return Q};O.prototype.getFullYear=function(){return this.proxy.getFullYear()};O.prototype.getGmtOffset=function(){var P=this.proxy.getTimezoneOffset()/60;var Q=P<0?"+":"-";P=Math.abs(P);return Q+A(Math.floor(P),2)+":"+A((P%1)*60,2)};O.prototype.getHours=function(){return this.proxy.getHours()};O.prototype.getHours12=function(){var P=this.proxy.getHours();return P>12?P-12:(P==0?12:P)};O.prototype.getIsoWeek=function(){var S=this.proxy;var R=S.getWeekOfYear();var P=(new Date(""+S.getFullYear()+"/1/1")).getDay();var Q=R+(P>4||P<=1?0:1);if(Q==53&&(new Date(""+S.getFullYear()+"/12/31")).getDay()<4){Q=1}else{if(Q===0){S=new O(new Date(""+(S.getFullYear()-1)+"/12/31"));Q=S.getIsoWeek()}}S=null;return Q};O.prototype.getMilliseconds=function(){return this.proxy.getMilliseconds()};O.prototype.getMinutes=function(){return this.proxy.getMinutes()};O.prototype.getMonth=function(){return this.proxy.getMonth()};O.prototype.getMonthName=function(){return O.regional[this.locale]["monthNames"][this.proxy.getMonth()]};O.prototype.getMonthNumber=function(){return this.proxy.getMonth()+1};O.prototype.getSeconds=function(){return this.proxy.getSeconds()};O.prototype.getShortYear=function(){return this.proxy.getYear()%100};O.prototype.getTime=function(){return this.proxy.getTime()};O.prototype.getTimezoneAbbr=function(){return this.proxy.toString().replace(/^.*\(([^)]+)\)$/,"$1")};O.prototype.getTimezoneName=function(){var P=/(?:\((.+)\)$| ([A-Z]{3}) )/.exec(this.toString());return P[1]||P[2]||"GMT"+this.getGmtOffset()};O.prototype.getTimezoneOffset=function(){return this.proxy.getTimezoneOffset()};O.prototype.getWeekOfYear=function(){var P=this.getDayOfYear();var R=7-this.getDayOfWeek();var Q=parseInt((P+R)/7,10);return Q};O.prototype.getUnix=function(){return Math.round(this.proxy.getTime()/1000,0)};O.prototype.getYear=function(){return this.proxy.getYear()};O.prototype.next=function(P){P=P||"day";return this.clone().add(1,P)};O.prototype.set=function(){switch(arguments.length){case 0:this.proxy=new Date();break;case 1:if(e(arguments[0])=="[object Object]"&&arguments[0]._type!="jsDate"){var R=this.options=arguments[0];this.syntax=R.syntax||this.syntax;this.defaultCentury=R.defaultCentury||this.defaultCentury;this.proxy=O.createDate(R.date)}else{this.proxy=O.createDate(arguments[0])}break;default:var P=[];for(var Q=0;Q<arguments.length;Q++){P.push(arguments[Q])}this.proxy=new Date(this.utcOffset);this.proxy.setFullYear.apply(this.proxy,P.slice(0,3));if(P.slice(3).length){this.proxy.setHours.apply(this.proxy,P.slice(3))}break}};O.prototype.setDate=function(P){return this.proxy.setDate(P)};O.prototype.setFullYear=function(){return this.proxy.setFullYear.apply(this.proxy,arguments)};O.prototype.setHours=function(){return this.proxy.setHours.apply(this.proxy,arguments)};O.prototype.setMilliseconds=function(P){return this.proxy.setMilliseconds(P)};O.prototype.setMinutes=function(){return this.proxy.setMinutes.apply(this.proxy,arguments)};O.prototype.setMonth=function(){return this.proxy.setMonth.apply(this.proxy,arguments)};O.prototype.setSeconds=function(){return this.proxy.setSeconds.apply(this.proxy,arguments)};O.prototype.setTime=function(P){return this.proxy.setTime(P)};O.prototype.setYear=function(){return this.proxy.setYear.apply(this.proxy,arguments)};O.prototype.strftime=function(P){P=P||this.formatString||O.regional[this.locale]["formatString"];return O.strftime(this,P,this.syntax)};O.prototype.toString=function(){return this.proxy.toString()};O.prototype.toYmdInt=function(){return(this.proxy.getFullYear()*10000)+(this.getMonthNumber()*100)+this.proxy.getDate()};O.regional={en:{monthNames:["January","February","March","April","May","June","July","August","September","October","November","December"],monthNamesShort:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],dayNames:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],dayNamesShort:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],formatString:"%Y-%m-%d %H:%M:%S"},fr:{monthNames:["Janvier","Février","Mars","Avril","Mai","Juin","Juillet","Août","Septembre","Octobre","Novembre","Décembre"],monthNamesShort:["Jan","Fév","Mar","Avr","Mai","Jun","Jul","Aoû","Sep","Oct","Nov","Déc"],dayNames:["Dimanche","Lundi","Mardi","Mercredi","Jeudi","Vendredi","Samedi"],dayNamesShort:["Dim","Lun","Mar","Mer","Jeu","Ven","Sam"],formatString:"%Y-%m-%d %H:%M:%S"},de:{monthNames:["Januar","Februar","März","April","Mai","Juni","Juli","August","September","Oktober","November","Dezember"],monthNamesShort:["Jan","Feb","Mär","Apr","Mai","Jun","Jul","Aug","Sep","Okt","Nov","Dez"],dayNames:["Sonntag","Montag","Dienstag","Mittwoch","Donnerstag","Freitag","Samstag"],dayNamesShort:["So","Mo","Di","Mi","Do","Fr","Sa"],formatString:"%Y-%m-%d %H:%M:%S"},es:{monthNames:["Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"],monthNamesShort:["Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Sep","Oct","Nov","Dic"],dayNames:["Domingo","Lunes","Martes","Mi&eacute;rcoles","Jueves","Viernes","S&aacute;bado"],dayNamesShort:["Dom","Lun","Mar","Mi&eacute;","Juv","Vie","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"},ru:{monthNames:["Январь","Февраль","Март","Апрель","Май","Июнь","Июль","Август","Сентябрь","Октябрь","Ноябрь","Декабрь"],monthNamesShort:["Янв","Фев","Мар","Апр","Май","Июн","Июл","Авг","Сен","Окт","Ноя","Дек"],dayNames:["воскресенье","понедельник","вторник","среда","четверг","пятница","суббота"],dayNamesShort:["вск","пнд","втр","срд","чтв","птн","сбт"],formatString:"%Y-%m-%d %H:%M:%S"},ar:{monthNames:["كانون الثاني","شباط","آذار","نيسان","آذار","حزيران","تموز","آب","أيلول","تشرين الأول","تشرين الثاني","كانون الأول"],monthNamesShort:["1","2","3","4","5","6","7","8","9","10","11","12"],dayNames:["السبت","الأحد","الاثنين","الثلاثاء","الأربعاء","الخميس","الجمعة"],dayNamesShort:["سبت","أحد","اثنين","ثلاثاء","أربعاء","خميس","جمعة"],formatString:"%Y-%m-%d %H:%M:%S"},pt:{monthNames:["Janeiro","Fevereiro","Mar&ccedil;o","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],monthNamesShort:["Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out","Nov","Dez"],dayNames:["Domingo","Segunda-feira","Ter&ccedil;a-feira","Quarta-feira","Quinta-feira","Sexta-feira","S&aacute;bado"],dayNamesShort:["Dom","Seg","Ter","Qua","Qui","Sex","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"},"pt-BR":{monthNames:["Janeiro","Fevereiro","Mar&ccedil;o","Abril","Maio","Junho","Julho","Agosto","Setembro","Outubro","Novembro","Dezembro"],monthNamesShort:["Jan","Fev","Mar","Abr","Mai","Jun","Jul","Ago","Set","Out","Nov","Dez"],dayNames:["Domingo","Segunda-feira","Ter&ccedil;a-feira","Quarta-feira","Quinta-feira","Sexta-feira","S&aacute;bado"],dayNamesShort:["Dom","Seg","Ter","Qua","Qui","Sex","S&aacute;b"],formatString:"%Y-%m-%d %H:%M:%S"}};O.regional["en-US"]=O.regional["en-GB"]=O.regional.en;O.regional.getLocale=function(){var P=O.config.defaultLocale;if(document&&document.getElementsByTagName("html")&&document.getElementsByTagName("html")[0].lang){P=document.getElementsByTagName("html")[0].lang;if(!O.regional.hasOwnProperty(P)){P=O.config.defaultLocale}}return P};var r=24*60*60*1000;var A=function(P,S){P=String(P);var Q=S-P.length;var R=String(Math.pow(10,Q)).slice(1);return R.concat(P)};var u={millisecond:1,second:1000,minute:60*1000,hour:60*60*1000,day:r,week:7*r,month:{add:function(R,P){u.year.add(R,Math[P>0?"floor":"ceil"](P/12));var Q=R.getMonth()+(P%12);if(Q==12){Q=0;R.setYear(R.getFullYear()+1)}else{if(Q==-1){Q=11;R.setYear(R.getFullYear()-1)}}R.setMonth(Q)},diff:function(T,R){var P=T.getFullYear()-R.getFullYear();var Q=T.getMonth()-R.getMonth()+(P*12);var S=T.getDate()-R.getDate();return Q+(S/30)}},year:{add:function(Q,P){Q.setYear(Q.getFullYear()+Math[P>0?"floor":"ceil"](P))},diff:function(Q,P){return u.month.diff(Q,P)/12}}};for(var H in u){if(H.substring(H.length-1)!="s"){u[H+"s"]=u[H]}}var w=function(T,S,Q){if(O.formats[Q]["shortcuts"][S]){return O.strftime(T,O.formats[Q]["shortcuts"][S],Q)}else{var P=(O.formats[Q]["codes"][S]||"").split(".");var R=T["get"+P[0]]?T["get"+P[0]]():"";if(P[1]){R=A(R,P[1])}return R}};O.strftime=function(V,S,R,W){var Q="perl";var U=O.regional.getLocale();if(R&&O.formats.hasOwnProperty(R)){Q=R}else{if(R&&O.regional.hasOwnProperty(R)){U=R}}if(W&&O.formats.hasOwnProperty(W)){Q=W}else{if(W&&O.regional.hasOwnProperty(W)){U=W}}if(e(V)!="[object Object]"||V._type!="jsDate"){V=new O(V);V.locale=U}if(!S){S=V.formatString||O.regional[U]["formatString"]}var P=S||"%Y-%m-%d",X="",T;while(P.length>0){if(T=P.match(O.formats[Q].codes.matcher)){X+=P.slice(0,T.index);X+=(T[1]||"")+w(V,T[2],Q);P=P.slice(T.index+T[0].length)}else{X+=P;P=""}}return X};O.formats={ISO:"%Y-%m-%dT%H:%M:%S.%N%G",SQL:"%Y-%m-%d %H:%M:%S"};O.formats.perl={codes:{matcher:/()%(#?(%|[a-z]))/i,Y:"FullYear",y:"ShortYear.2",m:"MonthNumber.2","#m":"MonthNumber",B:"MonthName",b:"AbbrMonthName",d:"Date.2","#d":"Date",e:"Date",A:"DayName",a:"AbbrDayName",w:"Day",H:"Hours.2","#H":"Hours",I:"Hours12.2","#I":"Hours12",p:"AMPM",M:"Minutes.2","#M":"Minutes",S:"Seconds.2","#S":"Seconds",s:"Unix",N:"Milliseconds.3","#N":"Milliseconds",O:"TimezoneOffset",Z:"TimezoneName",G:"GmtOffset"},shortcuts:{F:"%Y-%m-%d",T:"%H:%M:%S",X:"%H:%M:%S",x:"%m/%d/%y",D:"%m/%d/%y","#c":"%a %b %e %H:%M:%S %Y",v:"%e-%b-%Y",R:"%H:%M",r:"%I:%M:%S %p",t:"\t",n:"\n","%":"%"}};O.formats.php={codes:{matcher:/()%((%|[a-z]))/i,a:"AbbrDayName",A:"DayName",d:"Date.2",e:"Date",j:"DayOfYear.3",u:"DayOfWeek",w:"Day",U:"FullWeekOfYear.2",V:"IsoWeek.2",W:"WeekOfYear.2",b:"AbbrMonthName",B:"MonthName",m:"MonthNumber.2",h:"AbbrMonthName",C:"Century.2",y:"ShortYear.2",Y:"FullYear",H:"Hours.2",I:"Hours12.2",l:"Hours12",p:"AMPM",P:"AmPm",M:"Minutes.2",S:"Seconds.2",s:"Unix",O:"TimezoneOffset",z:"GmtOffset",Z:"TimezoneAbbr"},shortcuts:{D:"%m/%d/%y",F:"%Y-%m-%d",T:"%H:%M:%S",X:"%H:%M:%S",x:"%m/%d/%y",R:"%H:%M",r:"%I:%M:%S %p",t:"\t",n:"\n","%":"%"}};O.createDate=function(Q){if(Q==null){return new Date()}if(Q instanceof Date){return Q}if(typeof Q=="number"){return new Date(Q)}var U=String(Q).replace(/^\s*(.+)\s*$/g,"$1");U=U.replace(/^([0-9]{1,4})-([0-9]{1,2})-([0-9]{1,4})/,"$1/$2/$3");U=U.replace(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{4})/i,"$1 $2 $3");var T=U.match(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{2})\D*/i);if(T&&T.length>3){var Y=parseFloat(T[3]);var S=O.config.defaultCentury+Y;S=String(S);U=U.replace(/^(3[01]|[0-2]?\d)[-\/]([a-z]{3,})[-\/](\d{2})\D*/i,T[1]+" "+T[2]+" "+S)}T=U.match(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})[^0-9]/);function X(ac,ab){var ah=parseFloat(ab[1]);var ag=parseFloat(ab[2]);var af=parseFloat(ab[3]);var ae=O.config.defaultCentury;var aa,Z,ai,ad;if(ah>31){Z=af;ai=ag;aa=ae+ah}else{Z=ag;ai=ah;aa=ae+af}ad=ai+"/"+Z+"/"+aa;return ac.replace(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})/,ad)}if(T&&T.length>3){U=X(U,T)}var T=U.match(/^([0-9]{1,2})[-\/]([0-9]{1,2})[-\/]([0-9]{1,2})$/);if(T&&T.length>3){U=X(U,T)}var R=0;var P=O.matchers.length;var W;var V=U;while(R<P){ms=Date.parse(V);if(!isNaN(ms)){return new Date(ms)}W=O.matchers[R];if(typeof W=="function"){obj=W.call(O,V);if(obj instanceof Date){return obj}}else{V=U.replace(W[0],W[1])}R++}return NaN};O.daysInMonth=function(P,Q){if(Q==2){return new Date(P,1,29).getDate()==29?29:28}return[l,31,l,31,30,31,30,31,31,30,31,30,31][Q]};O.matchers=[[/(3[01]|[0-2]\d)\s*\.\s*(1[0-2]|0\d)\s*\.\s*([1-9]\d{3})/,"$2/$1/$3"],[/([1-9]\d{3})\s*-\s*(1[0-2]|0\d)\s*-\s*(3[01]|[0-2]\d)/,"$2/$3/$1"],function(S){var Q=S.match(/^(?:(.+)\s+)?([012]?\d)(?:\s*\:\s*(\d\d))?(?:\s*\:\s*(\d\d(\.\d*)?))?\s*(am|pm)?\s*$/i);if(Q){if(Q[1]){var R=this.createDate(Q[1]);if(isNaN(R)){return}}else{var R=new Date();R.setMilliseconds(0)}var P=parseFloat(Q[2]);if(Q[6]){P=Q[6].toLowerCase()=="am"?(P==12?0:P):(P==12?12:P+12)}R.setHours(P,parseInt(Q[3]||0,10),parseInt(Q[4]||0,10),((parseFloat(Q[5]||0))||0)*1000);return R}else{return S}},function(S){var Q=S.match(/^(?:(.+))[T|\s+]([012]\d)(?:\:(\d\d))(?:\:(\d\d))(?:\.\d+)([\+\-]\d\d\:\d\d)$/i);if(Q){if(Q[1]){var R=this.createDate(Q[1]);if(isNaN(R)){return}}else{var R=new Date();R.setMilliseconds(0)}var P=parseFloat(Q[2]);R.setHours(P,parseInt(Q[3],10),parseInt(Q[4],10),parseFloat(Q[5])*1000);return R}else{return S}},function(T){var R=T.match(/^([0-3]?\d)\s*[-\/.\s]{1}\s*([a-zA-Z]{3,9})\s*[-\/.\s]{1}\s*([0-3]?\d)$/);if(R){var S=new Date();var U=O.config.defaultCentury;var W=parseFloat(R[1]);var V=parseFloat(R[3]);var Q,P,X;if(W>31){P=V;Q=U+W}else{P=W;Q=U+V}var X=K(R[2],O.regional[this.locale]["monthNamesShort"]);if(X==-1){X=K(R[2],O.regional[this.locale]["monthNames"])}S.setFullYear(Q,X,P);S.setHours(0,0,0,0);return S}else{return T}}];function K(R,S){if(S.indexOf){return S.indexOf(R)}for(var P=0,Q=S.length;P<Q;P++){if(S[P]===R){return P}}return -1}function e(P){if(P===null){return"[object Null]"}return Object.prototype.toString.call(P)}y.jsDate=O;y.jqplot.sprintf=function(){function V(ab,X,Y,aa){var Z=(ab.length>=X)?"":Array(1+X-ab.length>>>0).join(Y);return aa?ab+Z:Z+ab}function S(Y){value_str=new String(Y);for(var X=10;X>0;X--){if(value_str==(value_str=value_str.replace(/^(\d+)(\d{3})/,"$1"+y.jqplot.sprintf.thousandsSeparator+"$2"))){break}}return value_str}function R(ac,ab,ae,Z,aa,Y){var ad=Z-ac.length;if(ad>0){var X=" ";if(Y){X="&nbsp;"}if(ae||!aa){ac=V(ac,Z,X,ae)}else{ac=ac.slice(0,ab.length)+V("",ad,"0",true)+ac.slice(ab.length)}}return ac}function W(af,Y,ad,Z,X,ac,ae,ab){var aa=af>>>0;ad=ad&&aa&&{"2":"0b","8":"0","16":"0x"}[Y]||"";af=ad+V(aa.toString(Y),ac||0,"0",false);return R(af,ad,Z,X,ae,ab)}function P(ab,ac,Z,X,aa,Y){if(X!=null){ab=ab.slice(0,X)}return R(ab,"",ac,Z,aa,Y)}var Q=arguments,T=0,U=Q[T++];return U.replace(y.jqplot.sprintf.regex,function(ar,ae,af,ai,au,ap,ac){if(ar=="%%"){return"%"}var aj=false,ag="",ah=false,aq=false,ad=false,ab=false;for(var ao=0;af&&ao<af.length;ao++){switch(af.charAt(ao)){case" ":ag=" ";break;case"+":ag="+";break;case"-":aj=true;break;case"0":ah=true;break;case"#":aq=true;break;case"&":ad=true;break;case"'":ab=true;break}}if(!ai){ai=0}else{if(ai=="*"){ai=+Q[T++]}else{if(ai.charAt(0)=="*"){ai=+Q[ai.slice(1,-1)]}else{ai=+ai}}}if(ai<0){ai=-ai;aj=true}if(!isFinite(ai)){throw new Error("$.jqplot.sprintf: (minimum-)width must be finite")}if(!ap){ap="fFeE".indexOf(ac)>-1?6:(ac=="d")?0:void (0)}else{if(ap=="*"){ap=+Q[T++]}else{if(ap.charAt(0)=="*"){ap=+Q[ap.slice(1,-1)]}else{ap=+ap}}}var al=ae?Q[ae.slice(0,-1)]:Q[T++];switch(ac){case"s":if(al==null){return""}return P(String(al),aj,ai,ap,ah,ad);case"c":return P(String.fromCharCode(+al),aj,ai,ap,ah,ad);case"b":return W(al,2,aq,aj,ai,ap,ah,ad);case"o":return W(al,8,aq,aj,ai,ap,ah,ad);case"x":return W(al,16,aq,aj,ai,ap,ah,ad);case"X":return W(al,16,aq,aj,ai,ap,ah,ad).toUpperCase();case"u":return W(al,10,aq,aj,ai,ap,ah,ad);case"i":var Z=parseInt(+al,10);if(isNaN(Z)){return""}var an=Z<0?"-":ag;number_str=ab?S(String(Math.abs(Z))):String(Math.abs(Z));al=an+V(number_str,ap,"0",false);return R(al,an,aj,ai,ah,ad);case"d":var Z=Math.round(+al);if(isNaN(Z)){return""}var an=Z<0?"-":ag;number_str=ab?S(String(Math.abs(Z))):String(Math.abs(Z));al=an+V(number_str,ap,"0",false);return R(al,an,aj,ai,ah,ad);case"e":case"E":case"f":case"F":case"g":case"G":var Z=+al;if(isNaN(Z)){return""}var an=Z<0?"-":ag;var aa=["toExponential","toFixed","toPrecision"]["efg".indexOf(ac.toLowerCase())];var at=["toString","toUpperCase"]["eEfFgG".indexOf(ac)%2];number_str=Math.abs(Z)[aa](ap);number_str=ab?S(number_str):number_str;al=an+number_str;return R(al,an,aj,ai,ah,ad)[at]();case"p":case"P":var Z=+al;if(isNaN(Z)){return""}var an=Z<0?"-":ag;var ak=String(Number(Math.abs(Z)).toExponential()).split(/e|E/);var Y=(ak[0].indexOf(".")!=-1)?ak[0].length-1:ak[0].length;var am=(ak[1]<0)?-ak[1]-1:0;if(Math.abs(Z)<1){if(Y+am<=ap){al=an+Math.abs(Z).toPrecision(Y)}else{if(Y<=ap-1){al=an+Math.abs(Z).toExponential(Y-1)}else{al=an+Math.abs(Z).toExponential(ap-1)}}}else{var X=(Y<=ap)?Y:ap;al=an+Math.abs(Z).toPrecision(X)}var at=["toString","toUpperCase"]["pP".indexOf(ac)%2];return R(al,an,aj,ai,ah,ad)[at]();case"n":return"";default:return ar}})};y.jqplot.sprintf.thousandsSeparator=",";y.jqplot.sprintf.regex=/%%|%(\d+\$)?([-+#0&\' ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([nAscboxXuidfegpEGP])/g})(akeeba.jQuery);
